/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.PagePosition;
import org.ujac.print.tag.BaseImageTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.StickyTag;

public class BackgroundImageTag
extends BaseImageTag {
    private static final AttributeDefinition IMAGE_SOURCE = CommonAttributes.IMAGE_SOURCE.cloneAttrDef().setRequired(false);
    public static final String TAG_NAME = "background-image";
    private PagePosition pos = null;
    private boolean scaleToFit = false;
    private float rotate = 0.0f;
    private int hAlign = 0;
    private int vAlign = 0;
    protected boolean antialiasing = false;
    private StickyTag stickyTag = null;

    public BackgroundImageTag() {
        super(TAG_NAME);
    }

    public BackgroundImageTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Inserts a image into the document. Images may be places absolutely on the page or relative to its parent item. The image gets loaded by the resource loader, which is specified at the document handler.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(IMAGE_SOURCE).addDefinition(CommonAttributes.IMAGE_X).addDefinition(CommonAttributes.IMAGE_Y).addDefinition(CommonAttributes.IMAGE_WIDTH).addDefinition(CommonAttributes.IMAGE_HEIGHT).addDefinition(CommonAttributes.ROTATE).addDefinition(CommonAttributes.SCALE_TO_FIT).addDefinition(CommonAttributes.IMAGE_PAGE).addDefinition(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.IMAGE_X).addDefinition(CommonStyleAttributes.IMAGE_Y).addDefinition(CommonStyleAttributes.IMAGE_WIDTH).addDefinition(CommonStyleAttributes.IMAGE_HEIGHT).addDefinition(CommonStyleAttributes.SCALE_TO_FIT).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT);
    }

    public PagePosition getPosition() {
        return this.pos;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.stickyTag = (StickyTag)this.documentHandler.latestOfType("sticky");
        if (this.stickyTag == null) {
            throw new DocumentHandlerException(this.locator(), "The <" + this.getName() + "> tag needs to be nested within a <" + "sticky" + "> tag.");
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float x = this.getDimensionAttribute(CommonAttributes.IMAGE_X, true, CommonStyleAttributes.IMAGE_X);
        float y = this.getDimensionAttribute(CommonAttributes.IMAGE_Y, true, CommonStyleAttributes.IMAGE_Y);
        this.pos = new PagePosition(x, y);
        this.width = this.getDimensionAttribute(CommonAttributes.IMAGE_WIDTH, true, CommonStyleAttributes.IMAGE_WIDTH);
        this.height = this.getDimensionAttribute(CommonAttributes.IMAGE_HEIGHT, true, CommonStyleAttributes.IMAGE_HEIGHT);
        if (this.isAttributeSupported(CommonAttributes.SCALE_TO_FIT, CommonStyleAttributes.SCALE_TO_FIT)) {
            this.scaleToFit = this.getBooleanAttribute(CommonAttributes.SCALE_TO_FIT, false, true, CommonStyleAttributes.SCALE_TO_FIT);
        }
        this.rotate = this.getFloatAttribute(CommonAttributes.IMAGE_ROTATE, true, CommonStyleAttributes.IMAGE_ROTATE);
        if (this.isAttributeSupported(IMAGE_SOURCE)) {
            this.sourceAttr = this.getStringAttribute(IMAGE_SOURCE, true, null);
        }
        if (this.isAttributeSupported(CommonAttributes.IMAGE_PAGE)) {
            this.pageAttr = this.getStringAttribute(CommonAttributes.IMAGE_PAGE, true, null);
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.IMAGE_HORIZONTAL_ALIGNMENT);
        this.vAlign = this.getVerticalAlignmentAttribute(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT, true, CommonStyleAttributes.IMAGE_VERTICAL_ALIGNMENT);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        Image image = this.getImage();
        float width = this.width;
        float height = this.height;
        if (image != null) {
            float ph;
            float pw;
            if (width > 0.0f && height > 0.0f) {
                if (this.scaleToFit) {
                    image.scaleToFit(width, height);
                } else {
                    image.scaleAbsolute(width, height);
                }
            } else if (width > 0.0f) {
                pw = image.getPlainWidth();
                ph = image.getPlainHeight();
                image.scaleAbsolute(width, width / pw * ph);
            } else if (height > 0.0f) {
                pw = image.getPlainWidth();
                ph = image.getPlainHeight();
                image.scaleAbsolute(height / ph * pw, height);
            }
            if (this.rotate != 0.0f) {
                image.setRotation((float)Math.PI * this.rotate / 180.0f);
            }
            width = image.getScaledWidth();
            height = image.getScaledHeight();
            Document document = this.documentHandler.getDocument();
            Rectangle pageSize = document.getPageSize();
            if (!this.isAttributeDefined(CommonAttributes.IMAGE_Y, CommonStyleAttributes.IMAGE_Y)) {
                switch (this.vAlign) {
                    case 4: {
                        this.pos.setY(pageSize.getHeight() - document.bottomMargin() - height);
                        break;
                    }
                    case 6: {
                        this.pos.setY(document.topMargin());
                        break;
                    }
                    case 5: {
                        this.pos.setY(pageSize.getHeight() / 2.0f - height / 2.0f);
                        break;
                    }
                    default: {
                        this.pos.setY(document.topMargin());
                    }
                }
            }
            if (!this.isAttributeDefined(CommonAttributes.IMAGE_X, CommonStyleAttributes.IMAGE_X)) {
                switch (this.hAlign) {
                    case 0: {
                        this.pos.setX(document.leftMargin());
                        break;
                    }
                    case 2: {
                        this.pos.setX(pageSize.getWidth() - document.rightMargin() - width);
                        break;
                    }
                    case 1: {
                        this.pos.setX(pageSize.getWidth() / 2.0f - width / 2.0f);
                        break;
                    }
                    default: {
                        this.pos.setX(document.leftMargin());
                    }
                }
            }
            this.stickyTag.addStickyElementHandler(new ImagePageEventHandler(image));
        }
    }

    protected void insertImage(PdfWriter writer, Document document, Image image) {
        try {
            Rectangle pageSize = document.getPageSize();
            float x = this.pos.calcX(pageSize.getRight(), image.getScaledWidth());
            float y = this.pos.calcY(pageSize.getTop(), image.getScaledHeight());
            image.setAbsolutePosition(x, y);
            PdfContentByte cb = writer.getDirectContentUnder();
            cb.addImage(image);
        }
        catch (DocumentException ex) {
            this.log.error((Object)("Image output failed: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    class ImagePageEventHandler
    extends DocumentPageEventHandler {
        private Image image = null;

        public ImagePageEventHandler(Image image) {
            this.image = image;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            BackgroundImageTag.this.insertImage(writer, document, this.image);
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
        }

        public boolean isTemporary() {
            return false;
        }
    }
}

