/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PdfCellTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.util.StringUtils;

public abstract class BaseCellTag
extends BaseDocumentTag
implements ElementContainer,
PdfCellContainer,
PhraseHolder,
FontHolder,
StyleHolder {
    public static final int DEFAULT_HALIGN = 0;
    public static final int DEFAULT_VALIGN = 6;
    private static final AttributeDefinition CELL_ROTATE = CommonAttributes.ROTATE.cloneAttrDef("The rotation angle of the cell.");
    private static final AttributeDefinition CELL_ROTATE_STYLE = CommonStyleAttributes.ROTATE.cloneAttrDef("The rotation angle of the cell.");
    private CellAttributes cellAttributes = null;
    private PdfPCell cell = null;
    private PdfPCell nestedCell = null;
    private List cellEventHandlers = null;
    protected int colspan = 0;
    protected boolean fillRow = false;
    private Phrase phrase = null;
    protected boolean itemClosed = false;
    protected boolean composite = false;
    private float rotate = 0.0f;

    public BaseCellTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Adds a cell to its surrounding table or surrounding cell.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.COLSPAN).addDefinition(CommonAttributes.FILL_ROW).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.CELL_HEIGHT).addDefinition(CELL_ROTATE).addDefinition(CommonAttributes.NO_WRAP);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.CELL_HEIGHT).addDefinition(CELL_ROTATE_STYLE).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 1)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 1)).addDefinition(new ChildDefinition(PdfCellTag.class, 0, 1)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 1)).addDefinition(new ChildDefinition(PrintTableTag.class, 0, 1)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(SpaceTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseAcroFieldTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.cellEventHandlers = null;
        this.composite = false;
        if (!this.isValid()) {
            return;
        }
        this.rotate = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, false, CommonStyleAttributes.ROTATE);
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseAttributes(this, this.getParentAttributes());
        if (this.isAttributeDefined(CommonAttributes.COLSPAN)) {
            this.colspan = this.getIntegerAttribute(CommonAttributes.COLSPAN, true, null);
        }
        if (this.isAttributeDefined(CommonAttributes.FILL_ROW)) {
            this.fillRow = this.getBooleanAttribute(CommonAttributes.FILL_ROW, true, null);
        }
        this.itemClosed = false;
        this.nestedCell = null;
        this.cell = null;
        this.phrase = null;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContentPhrase();
    }

    protected abstract CellAttributes getParentAttributes();

    private PdfPCell buildCell(Image embeddedImage) throws DocumentHandlerException {
        this.cell = new PdfPCell(embeddedImage);
        this.setupCell(this.cell);
        return this.cell;
    }

    private PdfPCell buildCell(PdfPCell embeddedCell) throws DocumentHandlerException {
        PdfPTable nestedTable = new PdfPTable(1);
        nestedTable.setWidthPercentage(100.0f);
        nestedTable.addCell(embeddedCell);
        this.composite = true;
        this.cell = new PdfPCell(nestedTable);
        this.setupCell(this.cell);
        return this.cell;
    }

    private PdfPCell buildCell(PdfPTable table) throws DocumentHandlerException {
        this.composite = true;
        this.cell = new PdfPCell();
        this.cell.addElement((Element)table);
        this.setupCell(this.cell);
        return this.cell;
    }

    private PdfPCell buildCell(Paragraph embeddedParagraph) throws DocumentHandlerException {
        this.composite = true;
        this.cell = new PdfPCell();
        this.flushContentPhrase();
        this.cell.addElement((Element)embeddedParagraph);
        this.setupCell(this.cell);
        return this.cell;
    }

    private PdfPCell buildCell(Phrase embeddedPhrase) throws DocumentHandlerException {
        this.cell = new PdfPCell(embeddedPhrase);
        this.setupCell(this.cell);
        return this.cell;
    }

    private PdfPCell buildCell(Element element) throws DocumentHandlerException {
        this.composite = true;
        this.cell = new PdfPCell();
        this.flushContentPhrase();
        this.cell.addElement(element);
        this.setupCell(this.cell);
        return this.cell;
    }

    protected PdfPCell buildCell() throws DocumentHandlerException {
        this.cell = this.nestedCell != null ? new PdfPCell(this.nestedCell) : new PdfPCell();
        this.setupCell(this.cell);
        return this.cell;
    }

    private void setupCell(PdfPCell cell) throws DocumentHandlerException {
        this.cellAttributes.setupCell(cell);
        if (cell != null) {
            Phrase phrase;
            if (this.cellEventHandlers != null) {
                cell.setCellEvent((PdfPCellEvent)new CellEventHandler(this.cellEventHandlers));
            }
            if ((phrase = cell.getPhrase()) != null && this.rotate != 0.0f) {
                cell.setPhrase(this.rotatePhrase(cell.getPhrase(), this.rotate));
            }
        }
    }

    public void addCellEventHandler(PdfPCellEvent eventHandler) {
        if (this.cellEventHandlers == null) {
            this.cellEventHandlers = new ArrayList();
        }
        this.cellEventHandlers.add(eventHandler);
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (element == null) {
            return;
        }
        if (this.nestedCell != null) {
            throw new DocumentHandlerException(this.locator(), "Can't hold elements and cells within a cell.");
        }
        if (this.cell == null) {
            switch (element.type()) {
                case 11: {
                    if (this.phrase == null) {
                        this.phrase = (Phrase)element;
                        break;
                    }
                    this.phrase.add((Object)element);
                    break;
                }
                case 12: {
                    this.cell = this.buildCell((Paragraph)element);
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.cell = this.buildCell((Image)element);
                    break;
                }
                case 14: {
                    this.composite = true;
                    this.cell = this.buildCell(element);
                    break;
                }
                case 23: {
                    this.cell = this.buildCell((PdfPTable)element);
                    break;
                }
                default: {
                    if (element instanceof PdfPCell) {
                        this.cell = this.buildCell((PdfPCell)element);
                        break;
                    }
                    if (element instanceof Phrase) {
                        if (this.phrase == null) {
                            this.phrase = (Phrase)element;
                            break;
                        }
                        this.phrase.add((Object)element);
                        break;
                    }
                    throw new DocumentHandlerException(this.locator(), "Cells musten't contain elements other than tables, phrases, images, lists, paragraphs or cells.");
                }
            }
            return;
        }
        switch (element.type()) {
            case 11: {
                if (this.phrase == null) {
                    this.phrase = (Phrase)element;
                    break;
                }
                this.phrase.add((Object)element);
                break;
            }
            case 12: 
            case 14: 
            case 23: 
            case 32: 
            case 34: 
            case 35: {
                this.flushContentPhrase();
                this.cell.addElement(element);
                break;
            }
            default: {
                if (element instanceof PdfPCell) {
                    this.cell.addElement(element);
                    break;
                }
                if (element instanceof Phrase) {
                    if (this.phrase == null) {
                        this.phrase = (Phrase)element;
                        break;
                    }
                    this.phrase.add((Object)element);
                    break;
                }
                throw new DocumentHandlerException(this.locator(), "Cells musten't contain elements other than tables, phrases, images, lists, paragraphs or cells.");
            }
        }
    }

    private void flushContentPhrase() throws DocumentHandlerException {
        if (this.phrase != null) {
            if (!this.isPhraseEmpty(this.phrase)) {
                if (this.cell == null) {
                    this.cell = this.buildCell(this.phrase);
                } else if (this.composite) {
                    Paragraph p = new Paragraph(this.phrase);
                    p.setAlignment(this.cellAttributes.getHAlign());
                    this.cell.addElement((Element)p);
                } else {
                    this.cell.getPhrase().add((Object)this.phrase);
                }
            }
            this.phrase = null;
        }
    }

    protected PdfPCell getCell() {
        return this.cell;
    }

    public boolean isTopLevel() {
        return false;
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (cell == null) {
            return;
        }
        if (this.nestedCell != null) {
            throw new DocumentHandlerException(this.locator(), "Can't hold more than one cell within a cell.");
        }
        if (this.cell == null) {
            this.nestedCell = cell;
            this.cell = this.buildCell(this.nestedCell);
            return;
        }
        throw new DocumentHandlerException(this.locator(), "Can't hold elements and cells within a cell.");
    }

    public int getRemainingPdfColumns() {
        return 1;
    }

    public PdfTableHolder getPdfTable() {
        return null;
    }

    public String getActualContent() {
        if (this.phrase == null) {
            Phrase cellPhrase;
            if (this.cell != null && (cellPhrase = this.cell.getPhrase()) != null) {
                return this.getPhraseContent(cellPhrase);
            }
            return super.getActualContent();
        }
        return this.getPhraseContent(this.phrase);
    }

    public void flushContent() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.itemClosed) {
            return;
        }
        if (this.isEmptyContent()) {
            this.resetContent();
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        this.phrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing());
        this.resetContent();
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
            if (this.isTrimBody()) {
                chunk = StringUtils.trimHead(chunk);
            }
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getLeading() {
        return this.cellAttributes.getLeading();
    }

    public float getLineSpacing() {
        return this.cellAttributes.getLineSpacing();
    }

    public CellAttributes getLocalCellAttributes() {
        return this.cellAttributes;
    }

    public CellAttributes getCellAttributes() {
        if (this.cellAttributes.getFixedHeight() <= 0.0f) {
            return this.cellAttributes;
        }
        CellAttributes safeCopy = (CellAttributes)this.cellAttributes.clone();
        safeCopy.setFixedHeight(-1.0f);
        return safeCopy;
    }

    class CellEventHandler
    implements PdfPCellEvent {
        private List cellEvents = null;

        public CellEventHandler(List cellEventHandlers) {
            this.cellEvents = cellEventHandlers;
        }

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            int numCellEventHandlers = this.cellEvents.size();
            for (int i = 0; i < numCellEventHandlers; ++i) {
                PdfPCellEvent eventHandler = (PdfPCellEvent)this.cellEvents.get(i);
                eventHandler.cellLayout(cell, position, canvases);
            }
        }
    }
}

