/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.HashMap;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.AttributeTag;
import org.ujac.print.tag.CustomTagBuilder;

public class CustomTagTag
extends BaseDocumentTag {
    private static final AttributeDefinition ALIAS = new AttributeDefinition("alias", 12, true, "The alias for the custom tag definition.");
    private static final AttributeDefinition TAG = new AttributeDefinition("tag", 12, false, "The name of the original tag.");
    public static final String TAG_NAME = "custom-tag";
    private String tagName = null;
    private String alias = null;
    private Map attributes = null;

    public CustomTagTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a custom document tag for more convenience and less typing.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(ALIAS).addDefinition(TAG);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(AttributeTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.alias = this.getStringAttribute(ALIAS, false, null);
        this.tagName = this.getStringAttribute(TAG, false, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.attributes = new HashMap();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.documentHandler.getTagFactory().registerTag(this.alias, new CustomTagBuilder(this.tagName, this.alias, this.attributes));
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }
}

