/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.lang.reflect.Field;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.JavascriptContainer;
import org.ujac.print.NewPageHandler;
import org.ujac.print.ParameterDefHolder;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.BoxTag;
import org.ujac.print.tag.ChapterTag;
import org.ujac.print.tag.ColorDefTag;
import org.ujac.print.tag.ColumnTextTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.CustomTagTag;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.EncryptionTag;
import org.ujac.print.tag.FontDefTag;
import org.ujac.print.tag.FooterTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.HeadTag;
import org.ujac.print.tag.HeaderTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.InsertDocumentTag;
import org.ujac.print.tag.JavascriptTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroDefTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.MetaTag;
import org.ujac.print.tag.ModuleTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.OverlayTag;
import org.ujac.print.tag.PageFormatTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.ParameterDefTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.RegisterFontTag;
import org.ujac.print.tag.RegisterTagTag;
import org.ujac.print.tag.ResourceBundleTag;
import org.ujac.print.tag.SegmentTag;
import org.ujac.print.tag.SetFormatTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.StickyTag;
import org.ujac.print.tag.StyleDefTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TableTag;
import org.ujac.print.tag.TocTag;
import org.ujac.print.tag.ViewerPreferencesTag;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.print.tag.graphics.GraphicsTag;
import org.ujac.util.template.TemplateContext;

public class DocumentTag
extends BaseDocumentTag
implements ElementContainer,
JavascriptContainer,
ParameterDefHolder,
NewPageHandler,
StyleHolder {
    public static final String TAG_NAME = "document";
    private Document document = null;
    private float lineSpacing = 1.2f;
    private char pdfVersion = (char)52;

    public DocumentTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Root element of the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.PAGE_SIZE).addDefinition(CommonAttributes.PAGE_WIDTH).addDefinition(CommonAttributes.PAGE_HEIGHT).addDefinition(CommonAttributes.PAGE_ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.PDF_VERSION).addDefinition(CommonAttributes.LOGICAL_PAGENUMBERING).addDefinition(CommonAttributes.LOGICAL_PAGETEXT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.PAGE_SIZE).addDefinition(CommonStyleAttributes.PAGE_WIDTH).addDefinition(CommonStyleAttributes.PAGE_HEIGHT).addDefinition(CommonStyleAttributes.PAGE_ROTATE).addDefinition(CommonStyleAttributes.MARGIN_LEFT).addDefinition(CommonStyleAttributes.MARGIN_RIGHT).addDefinition(CommonStyleAttributes.MARGIN_TOP).addDefinition(CommonStyleAttributes.MARGIN_BOTTOM).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.LINE_SPACING);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ViewerPreferencesTag.class, 0, 1)).addDefinition(new ChildDefinition(EncryptionTag.class, 0, 1)).addDefinition(new ChildDefinition(RegisterFontTag.class, 0, 999)).addDefinition(new ChildDefinition(RegisterTagTag.class, 0, 999)).addDefinition(new ChildDefinition(StyleDefTag.class, 0, 999)).addDefinition(new ChildDefinition(ColorDefTag.class, 0, 999)).addDefinition(new ChildDefinition(FontDefTag.class, 0, 999)).addDefinition(new ChildDefinition(ModuleTag.class, 0, 999)).addDefinition(new ChildDefinition(ParameterDefTag.class, 0, 999)).addDefinition(new ChildDefinition(CustomTagTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroDefTag.class, 0, 999)).addDefinition(new ChildDefinition(HeadTag.class, 0, 999)).addDefinition(new ChildDefinition(PageFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(HeaderTag.class, 0, 1)).addDefinition(new ChildDefinition(FooterTag.class, 0, 1)).addDefinition(new ChildDefinition(StickyTag.class, 0, 1)).addDefinition(new ChildDefinition(SegmentTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(TocTag.class, 0, 999)).addDefinition(new ChildDefinition(IndexTag.class, 0, 999)).addDefinition(new ChildDefinition(ChapterTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 999)).addDefinition(new ChildDefinition(TableTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 999)).addDefinition(new ChildDefinition(PrintTableTag.class, 0, 999)).addDefinition(new ChildDefinition(SetFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(ResourceBundleTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(MetaTag.class, 0, 1)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(OverlayTag.class, 0, 999)).addDefinition(new ChildDefinition(BoxTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AddRowTag.class, 0, 999)).addDefinition(new ChildDefinition(AssertTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NewPageTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ColumnTextTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseAcroFieldTag.class, 0, 999)).addDefinition(new ChildDefinition(GraphicsTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(InsertDocumentTag.class, 0, 999)).addDefinition(new ChildDefinition(JavascriptTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isDocumentRoot() {
        return true;
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        Rectangle size = null;
        String sizeAttr = this.getStringAttribute(CommonAttributes.PAGE_SIZE, true, CommonStyleAttributes.PAGE_SIZE);
        if (sizeAttr != null) {
            try {
                Field sizeField = PageSize.class.getField(sizeAttr);
                size = (Rectangle)sizeField.get(null);
            }
            catch (Exception e) {
                throw new DocumentHandlerException(this.locator(), "Unable to set page size: " + e.getMessage(), e);
            }
        } else if (this.isAttributeDefined(CommonAttributes.PAGE_WIDTH, CommonStyleAttributes.PAGE_WIDTH) && this.isAttributeDefined(CommonAttributes.PAGE_HEIGHT, CommonStyleAttributes.PAGE_HEIGHT)) {
            float width = this.getDimensionAttribute(CommonAttributes.PAGE_WIDTH, true, CommonStyleAttributes.PAGE_WIDTH);
            float height = this.getDimensionAttribute(CommonAttributes.PAGE_HEIGHT, true, CommonStyleAttributes.PAGE_HEIGHT);
            size = new Rectangle(width, height);
        }
        this.lineSpacing = this.getDimensionAttribute(CommonAttributes.LINE_SPACING, 1.2f, true, CommonStyleAttributes.LINE_SPACING);
        if (size != null) {
            String rotateAttr = this.getStringAttribute(CommonAttributes.ROTATE, true, CommonStyleAttributes.ROTATE);
            boolean rotate = false;
            if (rotateAttr != null) {
                rotate = new Boolean(rotateAttr);
            }
            Color bgColor = this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR);
            float marginLeft = this.getDimensionAttribute(CommonAttributes.MARGIN_LEFT, true, CommonStyleAttributes.MARGIN_LEFT);
            float marginRight = this.getDimensionAttribute(CommonAttributes.MARGIN_RIGHT, true, CommonStyleAttributes.MARGIN_RIGHT);
            float marginTop = this.getDimensionAttribute(CommonAttributes.MARGIN_TOP, true, CommonStyleAttributes.MARGIN_TOP);
            float marginBottom = this.getDimensionAttribute(CommonAttributes.MARGIN_BOTTOM, true, CommonStyleAttributes.MARGIN_BOTTOM);
            this.pdfVersion = (char)(this.getIntegerAttribute(CommonAttributes.PDF_VERSION, 4, true, null) + 48);
            if (rotate) {
                size = size.rotate();
            }
            if (bgColor != null) {
                size.setBackgroundColor(bgColor);
            }
            if (this.isAttributeDefined(CommonAttributes.LOGICAL_PAGENUMBERING)) {
                int logicalPageNumberStyle = this.getIntegerAttribute(CommonAttributes.LOGICAL_PAGENUMBERING, true, null);
                this.documentHandler.setLogicalPageNumberStyle(logicalPageNumberStyle);
            }
            if (this.isAttributeDefined(CommonAttributes.LOGICAL_PAGETEXT)) {
                String logicalPageNumberText = this.getStringAttribute(CommonAttributes.LOGICAL_PAGETEXT, "", true, null);
                this.documentHandler.setLogicalPageNumberText(logicalPageNumberText);
            }
            this.document = new Document(size, marginLeft, marginRight, marginTop, marginBottom);
            this.documentHandler.setDocument(this.document);
            if (this.isAttributeDefined(CommonAttributes.PDF_VERSION)) {
                ((PdfWriter)this.documentHandler.getDocumentWriter(false)).setPdfVersion(this.pdfVersion);
            }
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (this.document != null) {
            this.document.close();
        }
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        try {
            Document document = this.getDocument(true);
            if (item instanceof ParagraphTag) {
                ParagraphTag tag = (ParagraphTag)item;
                float leading = tag.getLeading();
                float lineSpacing = tag.getLineSpacing();
                this.extendLeading((Phrase)((Paragraph)element), item.getFont().getFont(), leading, lineSpacing);
            }
            document.add(element);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add element <" + item.getName() + "> to the " + this.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public boolean isTopLevel() {
        return true;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public float getLeading() {
        return 0.0f;
    }

    public Document getDocument() {
        return this.getDocument(true);
    }

    protected void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument(boolean openDocumentRequired) {
        if (openDocumentRequired && !this.document.isOpen()) {
            this.document.open();
        }
        return this.document;
    }

    public void setParameterDef(ParameterDefinition parameterDef) throws DocumentHandlerException {
        String paramName;
        TemplateContext ctx = this.documentHandler.getTemplateContext();
        Object paramValue = ctx.getProperty(paramName = parameterDef.getName());
        if (paramValue == null) {
            if (!parameterDef.isOptional()) {
                throw new DocumentHandlerException(this.locator(), "The mandatory document parameter '" + paramName + "' was not defined in the document properties.");
            }
            paramValue = parameterDef.getDefaultValue();
            if (paramValue != null) {
                ctx.setProperty(paramName, parameterDef.getDefaultValue());
            }
        } else {
            String attr = (String)parameterDef.getDefaultValue();
            if (attr != null) {
                switch (parameterDef.getType()) {
                    case 7: {
                        if (paramValue instanceof Boolean) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as boolean but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 2: {
                        if (paramValue instanceof Number) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as int but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 5: {
                        if (paramValue instanceof Number) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as float but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 6: {
                        if (paramValue instanceof Number) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as double but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 8: {
                        if (paramValue instanceof Date) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Date but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 9: {
                        if (!(paramValue instanceof Date)) {
                            throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Time but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                        }
                        if (paramValue instanceof Time) break;
                        paramValue = new Time(((Date)paramValue).getTime());
                        break;
                    }
                    case 10: {
                        if (!(paramValue instanceof Date)) {
                            throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Timestamp but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                        }
                        if (paramValue instanceof Timestamp) break;
                        paramValue = new Timestamp(((Timestamp)paramValue).getTime());
                        break;
                    }
                    case 1: {
                        if (paramValue instanceof String) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as String but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 22: {
                        if (paramValue instanceof Color || paramValue instanceof String) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Color but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 20: {
                        if (paramValue instanceof String) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Font but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                    case 21: {
                        if (paramValue instanceof String) break;
                        throw new DocumentHandlerException(this.locator(), "The document parameter '" + paramName + "' was declared as Format but was given as instance of class '" + paramValue.getClass().getName() + "'.");
                    }
                }
            }
        }
    }

    public Document handleNewPage(Rectangle size, Rectangle margins) throws DocumentHandlerException {
        try {
            if (size != null) {
                this.document.setPageSize(size);
            }
            if (margins != null) {
                this.document.setMargins(margins.getBorderWidthLeft(), margins.getBorderWidthRight(), margins.getBorderWidthTop(), margins.getBorderWidthBottom());
            }
            this.document.newPage();
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to start a new page: " + ex.getMessage(), ex);
        }
        return this.document;
    }

    public void addJavaScript(String code) {
        PdfWriter pdfWriter = (PdfWriter)this.documentHandler.getDocumentWriter();
        pdfWriter.addJavaScript(code);
    }
}

