/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.Condition;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.ConditionTag;

public class ElseTag
extends ConditionTag {
    public static final String TAG_NAME = "else";
    private Condition previousIf;

    public ElseTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Conditional item, which evalutes its content in case a previous if tag's condition didn't evaluate to true.";
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        if (this.previousIf == null) {
            try {
                this.previousIf = (Condition)((Object)this.getPreviousItem());
                if (this.previousIf == null) {
                    throw new DocumentHandlerException(this.locator(), "The 'else' item must follow immediately after a 'if' item.");
                }
            }
            catch (ClassCastException ex) {
                throw new DocumentHandlerException(this.locator(), "The 'else' item must follow immediately after a 'if' item.", ex);
            }
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            this.result = false;
            return;
        }
        this.result = !this.previousIf.isTrue();
    }
}

