/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Font;
import java.awt.Color;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class FontDefTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "font-def";
    private DocumentFont font = null;
    private String name = null;
    private Color color = null;
    private String family = "Helvetica";
    private String encoding = "Cp1252";
    private float size = 10.0f;
    int style = 0;
    private float textRise = 0.0f;

    public FontDefTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a logical font for the document. This defined font can be used by the font tag,  by setting its 'font-def' attribute or by serveral other tags by setting their 'font' attributes.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.FONT_NAME).addDefinition(CommonAttributes.FONT_COLOR).addDefinition(CommonAttributes.FONT_FAMILY).addDefinition(CommonAttributes.FONT_ENCODING).addDefinition(CommonAttributes.FONT_SIZE).addDefinition(CommonAttributes.FONT_STYLE).addDefinition(CommonAttributes.TEXT_RISE).addDefinition(CommonAttributes.STYLE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME.cloneAttrDef()).addDefinition(CommonStyleAttributes.FONT_COLOR.cloneAttrDef().addAlias("color")).addDefinition(CommonStyleAttributes.FONT_FAMILY.cloneAttrDef().addAlias("family")).addDefinition(CommonStyleAttributes.FONT_ENCODING.cloneAttrDef().addAlias("encoding")).addDefinition(CommonStyleAttributes.FONT_SIZE.cloneAttrDef().addAlias("size")).addDefinition(CommonStyleAttributes.FONT_STYLE.cloneAttrDef().addAlias("style")).addDefinition(CommonStyleAttributes.TEXT_RISE);
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        String styleAttribute;
        String encodingAttribute;
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.FONT_NAME, false, null);
        this.color = this.getColorAttribute(CommonAttributes.FONT_COLOR, true, CommonStyleAttributes.FONT_COLOR);
        String familyAttribute = this.getStringAttribute(CommonAttributes.FONT_FAMILY, true, CommonStyleAttributes.FONT_FAMILY);
        if (familyAttribute != null) {
            this.family = familyAttribute;
        }
        if ((encodingAttribute = this.getStringAttribute(CommonAttributes.FONT_ENCODING, true, CommonStyleAttributes.FONT_FAMILY)) != null) {
            this.encoding = encodingAttribute;
        }
        if (this.isAttributeDefined(CommonAttributes.FONT_SIZE, CommonStyleAttributes.FONT_SIZE)) {
            this.size = this.getDimensionAttribute(CommonAttributes.FONT_SIZE, true, CommonStyleAttributes.FONT_SIZE);
        }
        if ((styleAttribute = this.getStringAttribute(CommonAttributes.FONT_STYLE, true, CommonStyleAttributes.FONT_STYLE)) != null) {
            this.style = Font.getStyleValue((String)styleAttribute);
        } else {
            styleAttribute = this.getStringAttribute(CommonAttributes.STYLE, true, null);
            if (styleAttribute != null) {
                this.style = Font.getStyleValue((String)styleAttribute);
            }
        }
        if (this.isAttributeDefined(CommonAttributes.TEXT_RISE, CommonStyleAttributes.TEXT_RISE)) {
            this.textRise = this.getDimensionAttribute(CommonAttributes.TEXT_RISE, true, CommonStyleAttributes.TEXT_RISE);
        }
        this.font = this.createFont(this.family, this.encoding, this.size, this.style, this.textRise, this.color);
        this.documentHandler.registerFont(this.name, this.font);
    }

    protected void handleFontAttributes() throws DocumentHandlerException {
    }

    public DocumentFont getFont() {
        return this.font;
    }
}

