/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Font;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class FontTag
extends BaseFontTag {
    public static final String TAG_NAME = "font";
    public static final AttributeDefinition NAME = new AttributeDefinition("name", 12, false, "The font definition name, use this in case you want to make use of predefined fonts (see font-def item).").addAlias("font-def");

    public FontTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Sets the current font for the document. You can either hardcode a font here, or use a  predefined font definition (see 'font-def' item).";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(NAME).addDefinition(CommonAttributes.FONT_COLOR).addDefinition(CommonAttributes.FONT_FAMILY).addDefinition(CommonAttributes.FONT_ENCODING).addDefinition(CommonAttributes.FONT_SIZE).addDefinition(CommonAttributes.FONT_STYLE).addDefinition(CommonAttributes.TEXT_RISE).addDefinition(CommonAttributes.STYLE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.FONT_COLOR).addDefinition(CommonStyleAttributes.FONT_FAMILY).addDefinition(CommonStyleAttributes.FONT_ENCODING).addDefinition(CommonStyleAttributes.FONT_SIZE).addDefinition(CommonStyleAttributes.FONT_STYLE).addDefinition(CommonStyleAttributes.TEXT_RISE);
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public void openItem() throws DocumentHandlerException {
        String styleAttribute;
        String encodingAttribute;
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String fontDef = this.getStringAttribute(NAME, true, NAME);
        if (fontDef != null) {
            this.font = this.documentHandler.getFont(fontDef);
            return;
        }
        this.color = this.getColorAttribute(CommonAttributes.FONT_COLOR, true, CommonStyleAttributes.FONT_COLOR);
        String familyAttribute = this.getStringAttribute(CommonAttributes.FONT_FAMILY, true, CommonStyleAttributes.FONT_FAMILY);
        if (familyAttribute != null) {
            this.family = familyAttribute;
        }
        if ((encodingAttribute = this.getStringAttribute(CommonAttributes.FONT_ENCODING, true, CommonStyleAttributes.FONT_ENCODING)) != null) {
            this.encoding = encodingAttribute;
        }
        if (this.isAttributeDefined(CommonAttributes.FONT_SIZE, CommonStyleAttributes.FONT_SIZE)) {
            this.size = this.getDimensionAttribute(CommonAttributes.FONT_SIZE, true, CommonStyleAttributes.FONT_SIZE);
        }
        if ((styleAttribute = this.getStringAttribute(CommonAttributes.FONT_STYLE, true, CommonStyleAttributes.FONT_STYLE)) != null) {
            this.style = Font.getStyleValue((String)styleAttribute);
        } else {
            styleAttribute = this.getStringAttribute(CommonAttributes.STYLE, true, null);
            if (styleAttribute != null) {
                this.style = Font.getStyleValue((String)styleAttribute);
            }
        }
        if (this.isAttributeDefined(CommonAttributes.TEXT_RISE, CommonStyleAttributes.TEXT_RISE)) {
            this.textRise = this.getDimensionAttribute(CommonAttributes.TEXT_RISE, true, CommonStyleAttributes.TEXT_RISE);
        }
        this.font = this.createFont(this.family, this.encoding, this.size, this.style, this.textRise, this.color);
    }

    protected void handleFontAttributes() throws DocumentHandlerException {
    }
}

