/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.FooterTag;
import org.ujac.print.tag.HeaderFooterPartTag;

public class FooterPartTag
extends HeaderFooterPartTag {
    public static final String TAG_NAME = "footer-part";
    private static final float DEFAULT_PADDING = 10.0f;
    private float paddingTop = 10.0f;
    protected FooterTag footerTag = null;

    public FooterPartTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a part of the surrounding footer.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(X).addDefinition(WIDTH).addDefinition(CommonAttributes.BACKGROUND_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(X).addDefinition(WIDTH).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.footerTag = (FooterTag)this.documentHandler.latestOfType(FooterTag.class);
        if (this.footerTag == null) {
            throw new DocumentHandlerException(this.locator(), "The footer-part tag must be located below a footer tag!");
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.footerTag.addPart(this);
        this.paddingTop = this.getDimensionAttribute(CommonAttributes.PADDING_TOP, 10.0f, true, CommonStyleAttributes.PADDING_TOP);
    }

    protected float getVerticalPosition(Document document) {
        return document.getPageSize().getBottom() + document.bottomMargin() - this.paddingTop - this.footerTag.getPaddingTop();
    }

    public float getLineSpacing() {
        return this.footerTag.getLineSpacing();
    }
}

