/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.HeaderFooterPartTag;
import org.ujac.print.tag.HeaderTag;

public class HeaderPartTag
extends HeaderFooterPartTag {
    public static final String TAG_NAME = "header-part";
    private static final float DEFAULT_PADDING = 3.0f;
    private float paddingBottom = 3.0f;
    protected HeaderTag headerTag = null;

    public HeaderPartTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a part of the surrounding header.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(X).addDefinition(WIDTH).addDefinition(CommonAttributes.BACKGROUND_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(X).addDefinition(WIDTH).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.headerTag = (HeaderTag)this.documentHandler.latestOfType(HeaderTag.class);
        if (this.headerTag == null) {
            throw new DocumentHandlerException(this.locator(), "The header-part tag must be located below a header tag!");
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.headerTag.addPart(this);
        this.paddingBottom = this.getDimensionAttribute(CommonAttributes.PADDING_BOTTOM, 3.0f, true, CommonStyleAttributes.PADDING_BOTTOM);
    }

    protected float getVerticalPosition(Document document) {
        return document.getPageSize().getTop() - document.topMargin() + this.paddingBottom + this.headerTag.getPaddingBottom();
    }

    public float getLineSpacing() {
        return this.headerTag.getLineSpacing();
    }
}

