/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.ElementContainer;
import org.ujac.print.PagePosition;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.BaseImageTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.StickyTag;

public class ImageTag
extends BaseImageTag {
    public static final String TAG_NAME = "image";
    private PhraseHolder phraseHolder = null;
    private PagePosition pos = null;
    private boolean scaleToFit = false;
    private float rotate = 0.0f;
    private int hAlign = 0;
    private int vAlign = 0;
    private StickyTag stickyTag = null;

    public ImageTag() {
        super(TAG_NAME);
    }

    public ImageTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Inserts a image into the document. Images may be places absolutely on the page or relative to its parent item. The image gets loaded by the resource loader, which is specified at the document handler.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.IMAGE_SOURCE).addDefinition(CommonAttributes.IMAGE_X).addDefinition(CommonAttributes.IMAGE_Y).addDefinition(CommonAttributes.IMAGE_WIDTH).addDefinition(CommonAttributes.IMAGE_HEIGHT).addDefinition(CommonAttributes.SCALE_TO_FIT).addDefinition(CommonAttributes.IMAGE_ROTATE).addDefinition(CommonAttributes.IMAGE_PAGE).addDefinition(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.IMAGE_TEXTWRAP).addDefinition(CommonAttributes.IMAGE_UNDERLYING).addDefinition(CommonAttributes.IMAGE_DRAW_FOREGROUND);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.IMAGE_SOURCE).addDefinition(CommonStyleAttributes.IMAGE_X).addDefinition(CommonStyleAttributes.IMAGE_Y).addDefinition(CommonStyleAttributes.IMAGE_WIDTH).addDefinition(CommonStyleAttributes.IMAGE_HEIGHT).addDefinition(CommonStyleAttributes.SCALE_TO_FIT).addDefinition(CommonStyleAttributes.IMAGE_ROTATE).addDefinition(CommonStyleAttributes.IMAGE_HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.IMAGE_VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.IMAGE_TEXTWRAP).addDefinition(CommonStyleAttributes.IMAGE_UNDERLYING).addDefinition(CommonStyleAttributes.IMAGE_DRAW_FOREGROUND);
    }

    public PagePosition getPosition() {
        return this.pos;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
        this.stickyTag = (StickyTag)this.documentHandler.latestOfType("sticky");
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float x = this.getDimensionAttribute(CommonAttributes.IMAGE_X, true, CommonStyleAttributes.IMAGE_X);
        float y = this.getDimensionAttribute(CommonAttributes.IMAGE_Y, true, CommonStyleAttributes.IMAGE_Y);
        this.pos = new PagePosition(x, y);
        this.width = this.getDimensionAttribute(CommonAttributes.IMAGE_WIDTH, true, CommonStyleAttributes.IMAGE_WIDTH);
        this.height = this.getDimensionAttribute(CommonAttributes.IMAGE_HEIGHT, true, CommonStyleAttributes.IMAGE_HEIGHT);
        if (this.isAttributeSupported(CommonAttributes.SCALE_TO_FIT)) {
            this.scaleToFit = this.getBooleanAttribute(CommonAttributes.SCALE_TO_FIT, false, true, CommonStyleAttributes.SCALE_TO_FIT);
        }
        this.rotate = this.getFloatAttribute(CommonAttributes.IMAGE_ROTATE, true, CommonStyleAttributes.IMAGE_ROTATE);
        if (this.isAttributeSupported(CommonAttributes.IMAGE_SOURCE)) {
            this.sourceAttr = this.getStringAttribute(CommonAttributes.IMAGE_SOURCE, false, CommonStyleAttributes.IMAGE_SOURCE);
        }
        if (this.isAttributeSupported(CommonStyleAttributes.IMAGE_PAGE)) {
            this.pageAttr = this.getStringAttribute(CommonStyleAttributes.IMAGE_PAGE, true, CommonStyleAttributes.IMAGE_PAGE);
        }
        if (this.isAttributeDefined(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT, CommonStyleAttributes.IMAGE_HORIZONTAL_ALIGNMENT)) {
            this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.IMAGE_HORIZONTAL_ALIGNMENT);
        }
        if (this.isAttributeDefined(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT, CommonStyleAttributes.IMAGE_VERTICAL_ALIGNMENT)) {
            this.vAlign = this.getVerticalAlignmentAttribute(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT, true, CommonStyleAttributes.IMAGE_VERTICAL_ALIGNMENT);
        }
        if (this.getBooleanAttribute(CommonAttributes.IMAGE_TEXTWRAP, true, CommonStyleAttributes.IMAGE_TEXTWRAP)) {
            this.hAlign |= 4;
        }
        if (this.getBooleanAttribute(CommonAttributes.IMAGE_UNDERLYING, true, CommonStyleAttributes.IMAGE_UNDERLYING)) {
            this.hAlign |= 8;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        float ph;
        float pw;
        if (!this.isValid()) {
            return;
        }
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        float width = this.width;
        float height = this.height;
        if (width > 0.0f && height > 0.0f) {
            if (this.scaleToFit) {
                image.scaleToFit(width, height);
            } else {
                image.scaleAbsolute(width, height);
            }
        } else if (width > 0.0f) {
            pw = image.getPlainWidth();
            ph = image.getPlainHeight();
            image.scaleAbsolute(width, width / pw * ph);
        } else if (height > 0.0f) {
            pw = image.getPlainWidth();
            ph = image.getPlainHeight();
            image.scaleAbsolute(height / ph * pw, height);
        } else {
            image.setWidthPercentage(0.0f);
        }
        if (this.rotate != 0.0f) {
            image.setRotation((float)Math.PI * this.rotate / 180.0f);
        }
        width = image.getScaledWidth();
        height = image.getScaledHeight();
        Document document = this.documentHandler.getDocument();
        Rectangle pageSize = document.getPageSize();
        if (!this.isAttributeDefined(CommonAttributes.IMAGE_Y, CommonStyleAttributes.IMAGE_Y)) {
            switch (this.vAlign) {
                case 4: {
                    this.pos.setY(pageSize.getHeight() - document.bottomMargin() - height);
                    break;
                }
                case 6: {
                    this.pos.setY(document.topMargin());
                    break;
                }
                case 5: {
                    this.pos.setY(pageSize.getHeight() / 2.0f - height / 2.0f);
                    break;
                }
                default: {
                    this.pos.setY(document.topMargin());
                }
            }
        }
        if (this.isAttributeDefined(CommonAttributes.IMAGE_Y, CommonStyleAttributes.IMAGE_Y) || this.isAttributeDefined(CommonAttributes.IMAGE_VERTICAL_ALIGNMENT, CommonStyleAttributes.IMAGE_VERTICAL_ALIGNMENT)) {
            if (!this.isAttributeDefined(CommonAttributes.IMAGE_X, CommonStyleAttributes.IMAGE_X)) {
                switch (this.hAlign) {
                    case 0: {
                        this.pos.setX(document.leftMargin());
                        break;
                    }
                    case 2: {
                        this.pos.setX(pageSize.getWidth() - document.rightMargin() - width);
                        break;
                    }
                    case 1: {
                        this.pos.setX(pageSize.getWidth() / 2.0f - width / 2.0f);
                        break;
                    }
                    default: {
                        this.pos.setX(document.leftMargin());
                    }
                }
            }
            boolean drawForeground = this.getBooleanAttribute(CommonAttributes.IMAGE_DRAW_FOREGROUND, true, true, CommonStyleAttributes.IMAGE_DRAW_FOREGROUND);
            if (this.stickyTag != null) {
                this.stickyTag.addStickyElementHandler(new ImagePageEventHandler(image, drawForeground));
            } else {
                PdfWriter documentWriter = (PdfWriter)this.documentHandler.getDocumentWriter();
                if (drawForeground) {
                    this.insertImage(documentWriter, document, image, true);
                } else {
                    this.insertImage(documentWriter, document, image, false);
                }
            }
            return;
        }
        if (this.stickyTag != null) {
            this.log.warn((Object)"Usage with sticky tag only works for absolutely positioned images!");
        }
        ElementContainer elementContainer = this.getElementContainer();
        if (this.isAttributeDefined(CommonAttributes.IMAGE_HORIZONTAL_ALIGNMENT, CommonStyleAttributes.IMAGE_HORIZONTAL_ALIGNMENT)) {
            image.setAlignment(this.hAlign);
            elementContainer.addElement(this, (Element)image);
        } else {
            Chunk imgChunk = new Chunk(image, 0.0f, 0.0f);
            if (this.phraseHolder != null) {
                this.phraseHolder.addChunk(this, imgChunk);
            } else {
                elementContainer.addElement(this, (Element)imgChunk);
            }
        }
    }

    protected void insertImage(PdfWriter writer, Document document, Image image, boolean foreground) {
        try {
            Rectangle pageSize = document.getPageSize();
            float x = this.pos.calcX(pageSize.getRight(), image.getScaledWidth());
            float y = this.pos.calcY(pageSize.getTop(), image.getScaledHeight());
            image.setAbsolutePosition(x, y);
            PdfContentByte cb = null;
            cb = foreground ? writer.getDirectContent() : writer.getDirectContentUnder();
            cb.addImage(image);
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    class ImagePageEventHandler
    extends DocumentPageEventHandler {
        private Image image = null;
        private boolean foreground = true;

        public ImagePageEventHandler(Image image, boolean foreground) {
            this.image = image;
            this.foreground = foreground;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            ImageTag.this.insertImage(writer, document, this.image, this.foreground);
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
        }

        public boolean isTemporary() {
            return true;
        }
    }
}

