/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.io.IOException;
import java.io.StringReader;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.util.xml.XmlUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ImportTag
extends BaseDocumentTag {
    private static final AttributeDefinition SOURCE = new AttributeDefinition("source", 4, true, "The location of the document to import. This document is loaded using the ResourceLoader, specified at the DocumentHandler.");
    public static final String TAG_NAME = "import";
    private Object source = null;

    public ImportTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Imports a document part from an external source, this document gets loaded by the resource loader, which is specified at the document handler.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(SOURCE);
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.source = this.evalAttribute(SOURCE);
        try {
            XMLReader contentXmlReader = XmlUtils.createXmlReader(this.documentHandler.getXmlReaderClass());
            contentXmlReader.setContentHandler(this.documentHandler);
            XmlUtils.disableEntityResolver(contentXmlReader);
            byte[] importData = null;
            importData = this.source instanceof byte[] ? (byte[])this.source : this.documentHandler.loadResource(this.source.toString());
            String importText = new String(importData);
            this.documentHandler.disableTemplateCopyWriter();
            contentXmlReader.parse(new InputSource(new StringReader(importText)));
            this.documentHandler.enableTemplateCopyWriter();
        }
        catch (SAXException ex) {
            Exception cause = ex.getException();
            String at = "";
            if (cause instanceof DocumentHandlerException) {
                DocumentHandlerException dx = (DocumentHandlerException)cause;
                at = " at line " + dx.getLocator().getLineNumber();
            }
            throw new DocumentHandlerException(this.locator(), "Import of template '" + this.source + "' failed" + at + ":" + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Import of template '" + this.source + "' failed" + ex.getMessage(), ex);
        }
    }
}

