/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.PrintTableTag;

public class InsertColumnTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "insert-column";
    private PrintTableTag printTableTag = null;

    public InsertColumnTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Inserts a column into the surrounding &lt;print-table&gt; tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.COLUMN_NAME).addDefinition(CommonAttributes.COLUMN_WIDTH).addDefinition(CommonAttributes.COLUMN_REFERENCE).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT.cloneAttrDef()).addDefinition(CommonAttributes.COLUMN_TITLE).addDefinition(CommonAttributes.COLUMN_DIRECTION);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.printTableTag = (PrintTableTag)this.documentHandler.latestOfType(PrintTableTag.class);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (!this.printTableTag.isFirstLoop()) {
            return;
        }
        String name = this.getStringAttribute(CommonAttributes.COLUMN_NAME, true, null);
        float width = this.getFloatAttribute(CommonAttributes.COLUMN_WIDTH, -1.0f, true, null);
        int hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, -1, true, null);
        String title = this.getTextAttribute(CommonAttributes.COLUMN_TITLE, true, null);
        String reference = this.getStringAttribute(CommonAttributes.COLUMN_REFERENCE, true, null);
        String strDirection = this.getStringAttribute(CommonAttributes.COLUMN_DIRECTION, "after", true, null).toLowerCase();
        int direction = 2;
        if ("before".equals(strDirection)) {
            direction = 1;
        }
        this.printTableTag.insertColumn(name, width, hAlign, title, reference, direction, this.getContent());
    }
}

