/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentHolder;
import org.ujac.print.OutlineItem;

public class InsertDocumentTag
extends BaseDocumentTag {
    private static final AttributeDefinition SOURCE = new AttributeDefinition("source", 4, true, "The location of the document to insert at the current position.");
    private static final AttributeDefinition X = new AttributeDefinition("x", 14, false, "The horizontal offset for the page output.");
    private static final AttributeDefinition Y = new AttributeDefinition("y", 14, false, "The vertical offset for the page output.");
    private static final AttributeDefinition FROM = new AttributeDefinition("a", 14, false, "The number of the first page to insert from the source document.");
    private static final AttributeDefinition TO = new AttributeDefinition("to", 14, false, "The number of the last page to insert from the source document.");
    public static final String TAG_NAME = "insert-document";
    private Object source;
    private int from = -1;
    private int to = -1;

    public InsertDocumentTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Inserts a document at the current document position.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(SOURCE).addDefinition(FROM).addDefinition(TO).addDefinition(X).addDefinition(Y);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.source = this.evalAttribute(SOURCE);
        this.from = this.getIntegerAttribute(FROM, -1, true, null);
        this.to = this.getIntegerAttribute(TO, -1, true, null);
        float xOffset = this.getDimensionAttribute(X, 0.0f, true, (AttributeDefinition)null);
        float yOffset = this.getDimensionAttribute(Y, 0.0f, true, (AttributeDefinition)null);
        int page = 1;
        List outlineItems = null;
        boolean clearPageHandlers = false;
        try {
            PdfReader reader = null;
            if (this.source instanceof byte[]) {
                reader = new PdfReader((byte[])this.source);
            } else if (this.source instanceof DocumentHolder) {
                clearPageHandlers = true;
                DocumentHolder docHolder = (DocumentHolder)this.source;
                reader = new PdfReader(docHolder.getDocumentStream());
                outlineItems = docHolder.getOutlines();
            } else {
                reader = new PdfReader(this.documentHandler.loadResource(this.source.toString()));
            }
            PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
            int numPages = reader.getNumberOfPages();
            if (this.from > numPages) {
                throw new IOException("First page number (from) for imported document is out of range: " + this.from);
            }
            if (this.to < 0) {
                this.to = numPages;
            } else if (this.to > numPages) {
                throw new IOException("Last page number (to) for imported document is out of range: " + this.to);
            }
            if (this.from > this.to) {
                throw new IOException("Illegal page range: " + this.from + " to " + this.to + ".");
            }
            int firstPage = 1;
            if (this.from > 0) {
                firstPage = this.from;
            }
            page = firstPage;
            Document doc = this.documentHandler.getDocument();
            HashMap<String, PdfOutline> outlines = new HashMap<String, PdfOutline>();
            do {
                int rotation = reader.getPageRotation(page);
                PdfImportedPage importedPage = writer.getImportedPage(reader, page);
                Rectangle bbox = importedPage.getBoundingBox();
                if (rotation == 90 || rotation == 270) {
                    bbox = bbox.rotate();
                }
                doc.setPageSize(bbox);
                doc.newPage();
                float curXOffset = xOffset;
                float curYOffset = yOffset;
                if (clearPageHandlers) {
                    this.documentHandler.clearPageEventHandlers();
                }
                if (outlineItems != null) {
                    int numOutlineItems = outlineItems.size();
                    for (int i = 0; i < numOutlineItems; ++i) {
                        OutlineItem outlineItem = (OutlineItem)outlineItems.get(i);
                        if (outlineItem.getPage() != page) continue;
                        PdfOutline parentOutline = null;
                        String parent = outlineItem.getParent();
                        parentOutline = parent == null ? writer.getRootOutline() : (PdfOutline)outlines.get(parent);
                        float x = outlineItem.getX();
                        float y = outlineItem.getY();
                        if (this.documentHandler.isDestinationsSupported()) {
                            PdfDestination destination = null;
                            destination = x > 0.0f ? new PdfDestination(0, x, y, 0.0f) : new PdfDestination(2, y);
                            PdfContentByte directContent = writer.getDirectContent();
                            directContent.localDestination(outlineItem.getName(), destination);
                        }
                        PdfOutline outline = new PdfOutline(parentOutline, new PdfDestination(2, y), outlineItem.getTitle());
                        outlines.put(outlineItem.getName(), outline);
                    }
                }
                PdfContentByte directContent = writer.getDirectContent();
                if (rotation == 90 || rotation == 270) {
                    directContent.addTemplate((PdfTemplate)importedPage, 0.0f, -1.0f, 1.0f, 0.0f, curXOffset, bbox.getHeight() + curYOffset);
                    continue;
                }
                directContent.addTemplate((PdfTemplate)importedPage, curXOffset, curYOffset);
            } while (this.to <= 0 || ++page <= this.to);
        }
        catch (IllegalArgumentException ex) {
            if (page == this.from) {
                throw new DocumentHandlerException(this.locator(), "The page #" + page + " could not be loaded from document " + this.source + "'.", ex);
            }
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to load document from location '" + this.source + "': " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "The page #" + page + " could not be written to the document.", ex);
        }
    }
}

