/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ItemHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.ItemTag;

public class ItemsTag
extends BaseDocumentTag
implements ItemHolder {
    public static final String TAG_NAME = "items";
    private ItemHolder itemHolder = null;
    private List items = null;

    public ItemsTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Aggregates a list of items and adds these list to the surrounding item holder. Known item holders tags are: parameter.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ItemTag.class, 0, 999));
    }

    public boolean isTextBodyAllowed() {
        return false;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.itemHolder = (ItemHolder)((Object)this.documentHandler.latestOfType(ItemHolder.class));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.items = null;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.itemHolder.addItem(this.items);
    }

    public void addItem(Object item) throws TagAttributeException {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
    }

    public Object parseItem(String text) throws TagAttributeException {
        return this.itemHolder.parseItem(text);
    }
}

