/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Phrase;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SwitchTag;

public class ListItemTag
extends BaseElementTag
implements ElementContainer,
PhraseHolder,
FontHolder {
    public static final String TAG_NAME = "list-item";
    private ListTag listTag = null;
    private ListItem item = null;
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    private boolean keepTogether = false;
    private float spacingBefore = 0.0f;
    private float spacingAfter = 0.0f;
    private int hAlign = 0;
    private Phrase phrase = null;

    public ListItemTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds an item the the surrounding &lt;list&gt; tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.KEEP_TOGETHER).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.KEEP_TOGETHER).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(SpaceTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.listTag = (ListTag)this.documentHandler.latestOfType(ListTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.item = null;
        this.phrase = null;
        if (!this.isValid()) {
            return;
        }
        CommonAttributesHolder commonAttributesHolder = this.getCommonAttributesHolder();
        this.leading = this.isAttributeDefined(CommonAttributes.LEADING, CommonStyleAttributes.LEADING) ? this.getDimensionAttribute(CommonAttributes.LEADING, true, CommonStyleAttributes.LEADING) : commonAttributesHolder.getLeading();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : commonAttributesHolder.getLineSpacing();
        this.keepTogether = this.getBooleanAttribute(CommonAttributes.KEEP_TOGETHER, false, true, CommonStyleAttributes.KEEP_TOGETHER);
        this.spacingBefore = this.getDimensionAttribute(CommonAttributes.SPACING_BEFORE, 0.0f, true, CommonStyleAttributes.SPACING_BEFORE);
        this.spacingAfter = this.getDimensionAttribute(CommonAttributes.SPACING_AFTER, 0.0f, true, CommonStyleAttributes.SPACING_AFTER);
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
    }

    public String getActualContent() {
        if (this.phrase == null) {
            return super.getActualContent();
        }
        return this.getPhraseContent(this.phrase);
    }

    public void flushContent() throws DocumentHandlerException {
        Phrase nestedPhrase;
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.createPhrase();
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if ((nestedPhrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing())) != null) {
            this.phrase = nestedPhrase;
        }
        this.resetContent();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
        if (this.item == null) {
            this.createListItem();
        }
        this.listTag.addItem(this.item);
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.phrase.add((Object)element);
    }

    public boolean isTopLevel() {
        return false;
    }

    private void createPhrase() {
        this.phrase = new Phrase(0.0f);
    }

    public void addSubList(List sublist) {
        if (this.item == null) {
            this.createListItem();
        }
        this.item.add((Object)sublist);
    }

    private void createListItem() {
        Font font = this.getFont().getFont();
        this.item = new ListItem("", font);
        this.item.setAlignment(this.hAlign);
        this.item.add((Object)this.phrase);
        this.item.setSpacingBefore(this.spacingBefore);
        this.item.setSpacingAfter(this.spacingAfter);
        this.item.setLeading(this.phrase.getLeading());
        this.item.setKeepTogether(this.keepTogether);
    }
}

