/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.GreekList;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.RomanList;
import com.lowagie.text.ZapfDingbatsList;
import com.lowagie.text.ZapfDingbatsNumberList;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ListItemTag;
import org.ujac.print.tag.ListSymbolTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.SwitchTag;

public class ListTag
extends BaseElementTag
implements FontHolder {
    public static final float DEFAULT_SYMBOL_INDENT = 15.0f;
    public static final AttributeDefinition NUMBERED = new AttributeDefinition("numbered", 3, false, "Tells whether the list items are numbered or not.");
    public static final AttributeDefinition LETTERED = new AttributeDefinition("lettered", 3, false, "Tells whether the list items are lettered or not.");
    public static final AttributeDefinition SYMBOL_INDENT = new AttributeDefinition("symbol-indent", 1, false, "Specifies the symbol indention.");
    public static final AttributeDefinition LIST_TYPE = new AttributeDefinition("listtype", 4, false, "Specifies the type of list.The listtype can be only 'list', 'roman', 'greek' or 'zapfdingbats'.");
    public static final AttributeDefinition LIST_ITEMSTART = new AttributeDefinition("start", 1, false, "Specifies the numbering at which the list item should start.");
    public static final AttributeDefinition TYPE = new AttributeDefinition("type", 4, false, "Specifies the character to be used in the list.If the font used supports this char then it will be displayed else it will not.");
    public static final String TAG_NAME = "list";
    private float lineSpacing = 0.0f;
    private List list = null;
    private ListTag listTag = null;
    private ListItemTag listItemTag = null;
    private String listType = null;
    private char listChar = '\u0000';
    private int listStartAt = 1;

    public ListTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds an item to the surroundng list.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(NUMBERED).addDefinition(LETTERED).addDefinition(SYMBOL_INDENT).addDefinition(LIST_TYPE).addDefinition(LIST_ITEMSTART).addDefinition(TYPE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(NUMBERED).addDefinition(LETTERED).addDefinition(SYMBOL_INDENT);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(ListSymbolTag.class, 0, 1)).addDefinition(new ChildDefinition(ListItemTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.listItemTag = (ListItemTag)this.documentHandler.latestOfType(ListItemTag.class);
        if (this.listItemTag == null) {
            this.listTag = (ListTag)this.documentHandler.latestOfType(ListTag.class);
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING)) {
            this.lineSpacing = this.getDimensionAttribute(CommonAttributes.LINE_SPACING, 1.2f, true, CommonStyleAttributes.LINE_SPACING);
        } else if (this.listTag != null) {
            this.lineSpacing = this.listTag.getLineSpacing();
        } else {
            ElementContainer elementContainer = this.getElementContainer();
            this.lineSpacing = elementContainer.getLineSpacing();
        }
        this.listType = this.getStringAttribute(LIST_TYPE, TAG_NAME, true, null);
        this.listChar = this.getCharAttribute("type");
        this.listStartAt = this.getIntegerAttribute(LIST_ITEMSTART, 1, true, null);
        this.list = new List(this.getBooleanAttribute(NUMBERED, true, NUMBERED), this.getBooleanAttribute(LETTERED, true, LETTERED), this.getDimensionAttribute(SYMBOL_INDENT, 15.0f, true, SYMBOL_INDENT));
    }

    public char getCharAttribute(String name) throws TagAttributeException {
        char listChar = '\u0000';
        String attrValue = (String)this.evalAttribute(name);
        if (attrValue != null) {
            try {
                listChar = (char)Integer.valueOf(attrValue).intValue();
            }
            catch (NumberFormatException nfe) {
                listChar = this.getUnicodeChar(attrValue);
            }
        }
        return listChar;
    }

    public char getUnicodeChar(String s) {
        int i = 0;
        int len = s.length();
        char c = '\u0000';
        while (i < len) {
            if ((c = s.charAt(i++)) == '\\') {
                if (i >= len || (c = s.charAt(i++)) != 117) continue;
                c = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                break;
            }
            c = s.charAt(0);
        }
        return c;
    }

    public void setupList() throws DocumentHandlerException {
        if (TAG_NAME.equals(this.listType)) {
            this.list = new List(this.getBooleanAttribute(NUMBERED, true, NUMBERED), this.getBooleanAttribute(LETTERED, true, LETTERED), this.getFloatAttribute(SYMBOL_INDENT, 15.0f, true, SYMBOL_INDENT));
            this.list.setFirst(this.listStartAt);
            this.list.setListSymbol(new Character(this.listChar).toString());
        } else if ("roman".equals(this.listType)) {
            this.list = new RomanList(false, this.getIntegerAttribute(SYMBOL_INDENT, 15, true, SYMBOL_INDENT));
            this.list.setFirst(this.listStartAt);
        } else if ("greek".equals(this.listType)) {
            this.list = new GreekList(true, this.getIntegerAttribute(SYMBOL_INDENT, 15, true, SYMBOL_INDENT));
            this.list.setFirst(this.listStartAt);
        } else if ("zapfdingbats".equals(this.listType)) {
            if (this.getBooleanAttribute(NUMBERED, true, NUMBERED)) {
                this.list = new ZapfDingbatsNumberList((int)this.listChar, this.getIntegerAttribute(SYMBOL_INDENT, 15, true, SYMBOL_INDENT));
                this.list.setFirst(this.listStartAt);
            } else {
                this.list = new ZapfDingbatsList((int)this.listChar, this.getIntegerAttribute(SYMBOL_INDENT, 15, true, SYMBOL_INDENT));
                this.list.setFirst(this.listStartAt);
            }
        } else {
            throw new TagAttributeException(this.locator(), "Unsupported listType '" + this.listType + "'. The listtype can be only 'list', 'roman', 'greek' or 'zapfdingbats'.");
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.listItemTag != null) {
            this.listItemTag.addSubList(this.list);
        } else if (this.listTag != null) {
            this.listTag.addSubList(this.list);
        } else {
            ElementContainer elementContainer = this.getElementContainer();
            elementContainer.addElement(this, (Element)this.list);
        }
    }

    public void setListSymbol(Chunk symbol) {
        this.list.setListSymbol(symbol);
    }

    public void addSubList(List sublist) {
        this.list.add((Object)sublist);
    }

    public void addItem(ListItem item) {
        this.list.add((Object)item);
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }
}

