/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;

public class MetaTag
extends BaseDocumentTag {
    private static final AttributeDefinition TITLE = new AttributeDefinition("title", 4, false, "The title of the document.");
    private static final AttributeDefinition SUBJECT = new AttributeDefinition("subject", 4, false, "The subject of the document.");
    private static final AttributeDefinition KEYWORDS = new AttributeDefinition("keywords", 4, false, "The subject of the document.");
    private static final AttributeDefinition AUTHOR = new AttributeDefinition("author", 4, false, "The document's author.");
    private static final AttributeDefinition CREATOR = new AttributeDefinition("creator", 4, false, "The document's creator.");
    private static final AttributeDefinition CREATION_DATE = new AttributeDefinition("creation-date", 4, false, "Tells whether to add the creation date to the document or not.");
    public static final String TAG_NAME = "meta";

    public MetaTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds meta informations to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(TITLE).addDefinition(SUBJECT).addDefinition(KEYWORDS).addDefinition(AUTHOR).addDefinition(CREATOR).addDefinition(CREATION_DATE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        Document doc = this.getDocumentHandler().getDocument();
        if (this.isAttributeDefined(TITLE)) {
            doc.addTitle(this.getTextAttribute(TITLE, true, null));
        }
        if (this.isAttributeDefined(SUBJECT)) {
            doc.addSubject(this.getStringAttribute(SUBJECT, true, null));
        }
        if (this.isAttributeDefined(KEYWORDS)) {
            doc.addKeywords(this.getStringAttribute(KEYWORDS, true, null));
        }
        if (this.isAttributeDefined(AUTHOR)) {
            doc.addAuthor(this.getStringAttribute(AUTHOR, true, null));
        }
        if (this.isAttributeDefined(CREATOR)) {
            doc.addCreator(this.getStringAttribute(CREATOR, true, null));
        }
        if (this.getBooleanAttribute(CREATION_DATE, true, null)) {
            doc.addCreationDate();
        }
    }
}

