/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPageEvent;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.NewPageHandler;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.FooterTag;
import org.ujac.print.tag.HeaderTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.StickyTag;
import org.ujac.print.tag.SwitchTag;

public class NewPageTag
extends BaseDocumentTag {
    private static final AttributeDefinition LOGICAL_PAGENUMBERING = new AttributeDefinition("logical-pagestyle", 1, false, "The Logical Page Numbering style of the generated PDF (0: arabic numerals, 1: uppercase roman numerals, 2: lowercase roman numerals, 3: uppercase letters, 4: lowercase letters, 5: empty (No logical page numbers are generated but fixed text may still exist)).");
    private static final AttributeDefinition LOGICAL_PAGETEXT = new AttributeDefinition("logical-pagetext", 4, false, "The Logical Page Numbering style text of the generated PDF.");
    public static final String TAG_NAME = "new-page";
    protected NewPageHandler newPageHandler = null;
    private Map queuedEventHandlers = new HashMap();

    public NewPageTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Starts a new page.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.PAGE_SIZE).addDefinition(CommonAttributes.PAGE_WIDTH).addDefinition(CommonAttributes.PAGE_HEIGHT).addDefinition(CommonAttributes.ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(LOGICAL_PAGENUMBERING).addDefinition(LOGICAL_PAGETEXT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.PAGE_SIZE).addDefinition(CommonStyleAttributes.PAGE_WIDTH).addDefinition(CommonStyleAttributes.PAGE_HEIGHT).addDefinition(CommonStyleAttributes.ROTATE).addDefinition(CommonStyleAttributes.MARGIN_LEFT).addDefinition(CommonStyleAttributes.MARGIN_RIGHT).addDefinition(CommonStyleAttributes.MARGIN_TOP).addDefinition(CommonStyleAttributes.MARGIN_BOTTOM).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(LOGICAL_PAGENUMBERING).addDefinition(LOGICAL_PAGETEXT);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(HeaderTag.class, 0, 1)).addDefinition(new ChildDefinition(FooterTag.class, 0, 1)).addDefinition(new ChildDefinition(StickyTag.class, 0, 1));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.newPageHandler = (NewPageHandler)((Object)this.documentHandler.latestOfType(NewPageHandler.class));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.queuedEventHandlers.clear();
        if (this.isAttributeDefined(CommonAttributes.LOGICAL_PAGENUMBERING)) {
            int logicalPageNumberStyle = this.getIntegerAttribute(CommonAttributes.LOGICAL_PAGENUMBERING, true, null);
            this.documentHandler.setLogicalPageNumberStyle(logicalPageNumberStyle);
        }
        if (this.isAttributeDefined(CommonAttributes.LOGICAL_PAGETEXT)) {
            String logicalPageNumberText = this.getStringAttribute(CommonAttributes.LOGICAL_PAGETEXT, "", true, null);
            this.documentHandler.setLogicalPageNumberText(logicalPageNumberText);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        Rectangle size = null;
        String sizeAttr = this.getStringAttribute(CommonAttributes.PAGE_SIZE, true, CommonStyleAttributes.PAGE_SIZE);
        if (sizeAttr != null) {
            try {
                Field sizeField = PageSize.class.getField(sizeAttr);
                size = (Rectangle)sizeField.get(null);
            }
            catch (Exception e) {
                throw new DocumentHandlerException(this.locator(), "Unable to set page size: " + e.getMessage(), e);
            }
        } else if (this.isAttributeDefined(CommonAttributes.PAGE_WIDTH, CommonStyleAttributes.PAGE_WIDTH) && this.isAttributeDefined(CommonAttributes.PAGE_HEIGHT, CommonStyleAttributes.PAGE_HEIGHT)) {
            float width = this.getDimensionAttribute(CommonAttributes.PAGE_WIDTH, true, CommonStyleAttributes.PAGE_WIDTH);
            float height = this.getDimensionAttribute(CommonAttributes.PAGE_HEIGHT, true, CommonStyleAttributes.PAGE_HEIGHT);
            size = new Rectangle(width, height);
        }
        String rotateAttr = this.getStringAttribute(CommonAttributes.PAGE_ROTATE, true, CommonStyleAttributes.PAGE_ROTATE);
        boolean rotate = false;
        if (rotateAttr != null) {
            rotate = new Boolean(rotateAttr);
        }
        Color bgColor = this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR);
        boolean marginsDefined = this.isAttributeDefined(CommonAttributes.MARGIN_LEFT, CommonStyleAttributes.MARGIN_LEFT) && this.isAttributeDefined(CommonAttributes.MARGIN_RIGHT, CommonStyleAttributes.MARGIN_RIGHT) && this.isAttributeDefined(CommonAttributes.MARGIN_TOP, CommonStyleAttributes.MARGIN_TOP) && this.isAttributeDefined(CommonAttributes.MARGIN_BOTTOM, CommonStyleAttributes.MARGIN_BOTTOM);
        float marginLeft = this.getFloatAttribute(CommonAttributes.MARGIN_LEFT, true, CommonStyleAttributes.MARGIN_LEFT);
        float marginRight = this.getFloatAttribute(CommonAttributes.MARGIN_RIGHT, true, CommonStyleAttributes.MARGIN_RIGHT);
        float marginTop = this.getFloatAttribute(CommonAttributes.MARGIN_TOP, true, CommonStyleAttributes.MARGIN_TOP);
        float marginBottom = this.getFloatAttribute(CommonAttributes.MARGIN_BOTTOM, true, CommonStyleAttributes.MARGIN_BOTTOM);
        if (size == null) {
            size = new Rectangle(this.documentHandler.getDocument().getPageSize());
        }
        if (rotateAttr != null && rotate) {
            size = size.rotate();
        }
        if (bgColor != null) {
            size.setBackgroundColor(bgColor);
        }
        Rectangle margins = null;
        if (marginsDefined) {
            margins = new Rectangle(this.documentHandler.getDocument().getPageSize());
            margins.setBorderWidthLeft(marginLeft);
            margins.setBorderWidthRight(marginRight);
            margins.setBorderWidthTop(marginTop);
            margins.setBorderWidthBottom(marginBottom);
        }
        this.newPageHandler.handleNewPage(size, margins);
        Iterator iterQueuedEventHandlers = this.queuedEventHandlers.entrySet().iterator();
        while (iterQueuedEventHandlers.hasNext()) {
            Map.Entry entry = iterQueuedEventHandlers.next();
            this.documentHandler.setPageEventHandler(entry.getKey(), (PdfPageEvent)entry.getValue());
        }
    }

    public void queuePageEventHandler(Object key, PdfPageEvent handler) {
        this.queuedEventHandlers.put(key, handler);
    }
}

