/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.lang.reflect.Field;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DocumentTag;

public class PageFormatTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "page-format";
    protected DocumentTag documentItem = null;

    public PageFormatTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the page format.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.PAGE_SIZE).addDefinition(CommonAttributes.PAGE_WIDTH).addDefinition(CommonAttributes.PAGE_HEIGHT).addDefinition(CommonAttributes.PAGE_ROTATE).addDefinition(CommonAttributes.MARGIN_LEFT).addDefinition(CommonAttributes.MARGIN_RIGHT).addDefinition(CommonAttributes.MARGIN_TOP).addDefinition(CommonAttributes.MARGIN_BOTTOM).addDefinition(CommonAttributes.BACKGROUND_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.PAGE_SIZE).addDefinition(CommonStyleAttributes.PAGE_WIDTH).addDefinition(CommonStyleAttributes.PAGE_HEIGHT).addDefinition(CommonStyleAttributes.PAGE_ROTATE).addDefinition(CommonStyleAttributes.MARGIN_LEFT).addDefinition(CommonStyleAttributes.MARGIN_RIGHT).addDefinition(CommonStyleAttributes.MARGIN_TOP).addDefinition(CommonStyleAttributes.MARGIN_BOTTOM).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.documentItem = (DocumentTag)this.documentHandler.latestOfType("document");
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.documentItem.getDocument(false) != null) {
            throw new DocumentHandlerException(this.locator(), "Page format already defined!");
        }
        Rectangle size = null;
        String sizeAttr = this.getStringAttribute(CommonAttributes.PAGE_SIZE, true, CommonStyleAttributes.PAGE_SIZE);
        if (sizeAttr != null) {
            try {
                Field sizeField = PageSize.class.getField(sizeAttr);
                size = (Rectangle)sizeField.get(null);
            }
            catch (Exception e) {
                throw new DocumentHandlerException(this.locator(), "Unable to set page size: " + e.getMessage(), e);
            }
        } else if (this.isAttributeDefined(CommonAttributes.PAGE_WIDTH, CommonStyleAttributes.PAGE_WIDTH) && this.isAttributeDefined(CommonAttributes.PAGE_HEIGHT, CommonStyleAttributes.PAGE_HEIGHT)) {
            float width = this.getDimensionAttribute(CommonAttributes.PAGE_WIDTH, true, CommonStyleAttributes.PAGE_WIDTH);
            float height = this.getDimensionAttribute(CommonAttributes.PAGE_HEIGHT, true, CommonStyleAttributes.PAGE_HEIGHT);
            size = new Rectangle(width, height);
        }
        if (size != null) {
            String rotateAttr = this.getStringAttribute(CommonAttributes.PAGE_ROTATE, true, CommonStyleAttributes.PAGE_ROTATE);
            boolean rotate = false;
            if (rotateAttr != null) {
                rotate = new Boolean(rotateAttr);
            }
            Color bgColor = this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR);
            float marginLeft = this.getFloatAttribute(CommonAttributes.MARGIN_LEFT, true, CommonStyleAttributes.MARGIN_LEFT);
            float marginRight = this.getFloatAttribute(CommonAttributes.MARGIN_RIGHT, true, CommonStyleAttributes.MARGIN_RIGHT);
            float marginTop = this.getFloatAttribute(CommonAttributes.MARGIN_TOP, true, CommonStyleAttributes.MARGIN_TOP);
            float marginBottom = this.getFloatAttribute(CommonAttributes.MARGIN_BOTTOM, true, CommonStyleAttributes.MARGIN_BOTTOM);
            if (rotate) {
                size = size.rotate();
            }
            if (bgColor != null) {
                size.setBackgroundColor(bgColor);
            }
            Document document = new Document(size, marginLeft, marginRight, marginTop, marginBottom);
            this.documentHandler.setDocument(document);
            this.documentItem.setDocument(document);
        }
    }

    public void closeItem() throws DocumentHandlerException {
    }
}

