/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ParameterDefHolder;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.tag.CommonAttributes;

public class ParameterDefTag
extends BaseDocumentTag {
    private static final AttributeDefinition LIST_FLAG = new AttributeDefinition("list", 3, false, "The list flag.");
    private static final AttributeDefinition OPTIONAL_FLAG = new AttributeDefinition("optional", 3, false, "The optional flag.");
    private static final AttributeDefinition DEFAULT_VALUE = new AttributeDefinition("default-value", 4, false, "The default value, this only makes sense if the optional flag is defined as 'true'.");
    private static final AttributeDefinition PARAM_TYPE = new AttributeDefinition("type", new String[]{"int", "integer", "float", "long", "double", "date", "time", "timestamp", "string", "text", "object"}, false, "The attribute type.");
    private static final AttributeDefinition PARAM_DESCRIPTION = new AttributeDefinition("description", 4, false, "A description for the paremeter.");
    public static final String TAG_NAME = "parameter-def";
    private ParameterDefHolder parameterDefHolder = null;
    private String name = null;
    private String typeAttr = null;
    private int type = -1;
    private boolean list = false;
    private boolean optional = false;
    private Object defaultValue = null;
    private String description = null;

    public ParameterDefTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a parameter definition to its surrounding parameter definition holder.This could be a macro definition for example.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.PARAM_NAME).addDefinition(LIST_FLAG).addDefinition(OPTIONAL_FLAG).addDefinition(DEFAULT_VALUE).addDefinition(PARAM_TYPE).addDefinition(PARAM_DESCRIPTION);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parameterDefHolder = (ParameterDefHolder)((Object)this.documentHandler.latestOfType(ParameterDefHolder.class));
        if (this.parameterDefHolder == null) {
            throw new DocumentHandlerException(this.locator(), "Item '" + this.getName() + "' is not supported here.");
        }
        this.name = this.getStringAttribute(CommonAttributes.PARAM_NAME, false, null);
        this.typeAttr = this.getStringAttribute(PARAM_TYPE, "string", false, null).toLowerCase();
        if ("string".equals(this.typeAttr) || "text".equals(this.typeAttr)) {
            this.type = 1;
        } else if ("boolean".equals(this.typeAttr)) {
            this.type = 7;
        } else if ("int".equals(this.typeAttr) || "integer".equals(this.typeAttr)) {
            this.type = 2;
        } else if ("float".equals(this.typeAttr)) {
            this.type = 5;
        } else if ("double".equals(this.typeAttr)) {
            this.type = 6;
        } else if ("date".equals(this.typeAttr)) {
            this.type = 8;
        } else if ("time".equals(this.typeAttr)) {
            this.type = 9;
        } else if ("timestamp".equals(this.typeAttr)) {
            this.type = 10;
        } else if ("object".equals(this.typeAttr)) {
            this.type = 11;
        } else {
            throw new DocumentHandlerException(this.locator(), "Detected unsupported object type '" + this.typeAttr + "' at attribute '" + this.name + "'.");
        }
        String attr = this.getStringAttribute(DEFAULT_VALUE, false, null);
        this.defaultValue = this.typeCastValue(attr, this.typeAttr);
        this.optional = this.isAttributeDefined(OPTIONAL_FLAG) ? this.getBooleanAttribute(OPTIONAL_FLAG, false, null) : true;
        this.description = this.getStringAttribute(PARAM_DESCRIPTION, true, null);
    }

    public void closeItem() throws DocumentHandlerException {
        this.parameterDefHolder.setParameterDef(new ParameterDefinition(this.name, this.type, this.list, this.optional, this.defaultValue, this.description));
    }
}

