/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.FontHolder;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.PdfCellTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.SwitchTag;

public class PdfTableRowTag
extends BaseDocumentTag
implements PdfCellContainer,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "table-row";
    private CellAttributes cellAttributes = null;
    private PdfTableTag tableItem = null;
    private int numCells = 0;

    public PdfTableRowTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Controls the cells of a single row for the surrounding table. It automatically fills up the row with empty cells in case not all cells, definef by the table layout have been defined inside the row.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.CELL_HEIGHT).addDefinition(CommonAttributes.NO_WRAP);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.CELL_HEIGHT).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfCellTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.tableItem = (PdfTableTag)this.documentHandler.latestOfType(PdfTableTag.class);
        if (this.tableItem == null) {
            throw new DocumentHandlerException(this.locator(), "The table-header item must be located below a table!");
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.numCells = 0;
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseRowAttributes(this, this.tableItem.getCellAttributes());
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        int numRemainingCells = this.tableItem.getNumColumns() - this.numCells;
        if (numRemainingCells > 0) {
            PdfPCell filler = new PdfPCell();
            this.cellAttributes.setupCell(filler);
            filler.setColspan(numRemainingCells);
            this.tableItem.addCell(this, filler);
        }
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        this.numCells += Math.max(cell.getColspan(), 1);
        if (this.numCells > this.tableItem.getNumColumns()) {
            throw new DocumentHandlerException(this.locator(), "The row size exceeds the number of table columns.");
        }
        this.tableItem.addCell(item, cell);
    }

    public int getRemainingPdfColumns() {
        int tableColumns = this.tableItem.getNumColumns();
        return tableColumns - this.numCells % tableColumns;
    }

    public PdfTableHolder getPdfTable() {
        return this.tableItem;
    }

    public PdfPTable getTable() {
        return this.tableItem.getTable();
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }

    public float getLineSpacing() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLineSpacing();
        }
        return 1.2f;
    }

    public float getLeading() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLeading();
        }
        return 0.0f;
    }
}

