/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfPTable;
import org.ujac.print.Condition;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.FontHolder;
import org.ujac.print.tag.PrintRowTag;
import org.ujac.print.tag.RowCellContainer;
import org.ujac.util.table.Row;

public class PrintHeaderRowTag
extends PrintRowTag
implements FontHolder,
Condition,
RowCellContainer {
    public static final String TAG_NAME = "print-header-row";

    public PrintHeaderRowTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Prints the contents of table header rows.";
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.isTrue()) {
            this.rowContainer.splitTable(false, false);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        PdfPTable table;
        super.closeItem();
        if (!this.isValid()) {
            return;
        }
        if (this.isTrue() && (table = this.rowContainer.getTable()) != null) {
            table.setHeaderRows(this.rowContainer.getNumRows());
        }
    }

    public boolean isTrue() {
        Row currentRow = (Row)this.rowContainer.getCurrentValue();
        return currentRow != null && "header".equals(currentRow.getType());
    }

    protected boolean isHeaderRow() {
        return true;
    }
}

