/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.FontHolder;
import org.ujac.print.tag.BaseCellTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.RowCellContainer;

public class RowCellTag
extends BaseCellTag
implements FontHolder {
    public static final String TAG_NAME = "row-cell";
    private static final AttributeDefinition CELL_COLUMN_NAME = CommonAttributes.COLUMN_NAME.cloneAttrDef("The name of the column to define the attributes for.");
    private static final AttributeDefinition CELL_COLUMN_INDEX = CommonAttributes.COLUMN_INDEX.cloneAttrDef("The index of the column to define the attributes for.");
    private RowCellContainer rowCellContainer = null;
    protected String name = null;
    protected int index = -1;
    private String format = null;
    private float rotate = 0.0f;

    public RowCellTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Specifies the style of a cell for a specific column within the surrounding print-row tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CELL_COLUMN_NAME).addDefinition(CELL_COLUMN_INDEX).addDefinition(CommonAttributes.FORMAT);
    }

    public String getFormat() {
        return this.format;
    }

    public float getRotate() {
        return this.rotate;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.rowCellContainer = (RowCellContainer)((Object)this.documentHandler.latestOfType(RowCellContainer.class));
        if (this.rowCellContainer == null) {
            throw new DocumentHandlerException(this.locator(), "Unable to determine surrounding container for row-cell tag.");
        }
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.COLUMN_NAME, true, null);
        this.index = this.getIntegerAttribute(CommonAttributes.COLUMN_INDEX, -1, true, null);
        this.rotate = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, true, CommonStyleAttributes.ROTATE);
        this.format = this.getStringAttribute(CommonAttributes.FORMAT, true, null);
    }

    protected CellAttributes getParentAttributes() {
        return this.rowCellContainer.getCellAttributes();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        super.closeItem();
        this.itemClosed = true;
        this.rowCellContainer.registerRowCell(this);
    }

    public String getColumnName() {
        return this.name;
    }

    public int getColumnIndex() {
        return this.index;
    }
}

