/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.CommonAttributes;

public class SetFieldTag
extends BaseDocumentTag {
    private static final AttributeDefinition FIELD_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the field to set.");
    private static final AttributeDefinition FIELD_VALUE = new AttributeDefinition("value", 4, true, "The value to set for the field.");
    public static final String TAG_NAME = "set-field";
    private AddRowTag addRow = null;
    private String name = null;
    private String value = null;

    public SetFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Sets a field value at the surrounding table row.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FIELD_NAME).addDefinition(FIELD_VALUE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.addRow = (AddRowTag)this.documentHandler.latestOfType(AddRowTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.NAME, false, null);
        this.value = this.getStringAttribute(FIELD_VALUE, false, null);
        this.addRow.setFieldValue(this.name, this.value);
    }
}

