/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Font;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class SpanTag
extends BaseFontTag {
    public static final String TAG_NAME = "span";

    public SpanTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the style for the nested tags.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.FONT_COLOR).addDefinition(CommonAttributes.FONT_FAMILY).addDefinition(CommonAttributes.FONT_ENCODING).addDefinition(CommonAttributes.FONT_SIZE).addDefinition(CommonAttributes.FONT_STYLE).addDefinition(CommonAttributes.TEXT_RISE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.FONT_COLOR).addDefinition(CommonStyleAttributes.FONT_FAMILY).addDefinition(CommonStyleAttributes.FONT_ENCODING).addDefinition(CommonStyleAttributes.FONT_SIZE).addDefinition(CommonStyleAttributes.FONT_STYLE).addDefinition(CommonStyleAttributes.TEXT_RISE);
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String fontDef = this.getStringAttribute(CommonAttributes.FONT, true, CommonStyleAttributes.FONT_NAME);
        if (fontDef != null) {
            this.font = this.documentHandler.getFont(fontDef);
        }
        if (this.font != null) {
            this.family = this.font.getFamily();
            this.encoding = this.font.getEncoding();
            this.size = this.font.getSize();
            this.textRise = this.font.getTextRise();
            this.color = this.font.getColor();
        }
        this.color = this.getColorAttribute(CommonAttributes.FONT_COLOR, this.color, true, CommonStyleAttributes.FONT_COLOR);
        this.family = this.getStringAttribute(CommonAttributes.FONT_FAMILY, this.family, true, CommonStyleAttributes.FONT_FAMILY);
        this.encoding = this.getStringAttribute(CommonAttributes.FONT_ENCODING, this.encoding, true, CommonStyleAttributes.FONT_ENCODING);
        this.size = this.getDimensionAttribute(CommonAttributes.FONT_SIZE, this.size, true, CommonStyleAttributes.FONT_SIZE);
        String styleAttribute = this.getStringAttribute(CommonAttributes.FONT_STYLE, true, CommonStyleAttributes.FONT_STYLE);
        if (styleAttribute != null) {
            this.style = Font.getStyleValue((String)styleAttribute);
        } else {
            styleAttribute = this.getStringAttribute(CommonAttributes.STYLE, true, null);
            if (styleAttribute != null) {
                this.style = Font.getStyleValue((String)styleAttribute);
            }
        }
        this.textRise = this.getDimensionAttribute(CommonAttributes.TEXT_RISE, this.textRise, true, CommonStyleAttributes.TEXT_RISE);
        this.font = this.createFont(this.family, this.encoding, this.size, this.style, this.textRise, this.color);
    }
}

