/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.AttributeHandler;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.StyleParser;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.CollectionUtils;

public class StyleDefTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "style-def";
    private static final AttributeDefinition STYLE_DEF_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the style definition. In case you'd like to define thestyle for all occurrences of a tag, put the tag name here. In case the style should be valid for all tags, specify the tag name after a leading '.' character. Otherwise append the name to the tag name you'd like to define separated by a '.' character (example: cell.normal).");

    public StyleDefTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a style for the document. The style model aims to be similar to Cascading Style Sheets well known in HTML.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(STYLE_DEF_NAME).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.TEXT_RISE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_LEFT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_RIGHT_WIDTH).addDefinition(CommonStyleAttributes.BORDER_TOP_WIDTH).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.BORDER_LEFT_COLOR).addDefinition(CommonStyleAttributes.BORDER_RIGHT_COLOR).addDefinition(CommonStyleAttributes.BORDER_TOP_COLOR).addDefinition(CommonStyleAttributes.BORDER_BOTTOM_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.TEXT_RISE).addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.FONT_COLOR).addDefinition(CommonStyleAttributes.FONT_ENCODING).addDefinition(CommonStyleAttributes.FONT_FAMILY).addDefinition(CommonStyleAttributes.FONT_SIZE).addDefinition(CommonStyleAttributes.FONT_STYLE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        AttributeDefinition attrDef;
        int i;
        String styleDef;
        int dotIdx;
        String parentName;
        Map parentStyle;
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String name = this.getStringAttribute(CommonAttributes.NAME, false, null);
        HashMap styleMap = new HashMap();
        if (!name.startsWith(".") && name.indexOf(46) != -1 && (parentStyle = this.documentHandler.getStyle(parentName = name.substring((dotIdx = name.indexOf(46)) + 1))) != null) {
            styleMap.putAll(parentStyle);
        }
        CollectionUtils.put(styleMap, CommonStyleAttributes.FONT_NAME.getName(), this.getStringAttribute(CommonAttributes.FONT, true, CommonStyleAttributes.FONT_NAME));
        CollectionUtils.put(styleMap, CommonStyleAttributes.BACKGROUND_COLOR.getName(), this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR));
        if (this.isAttributeDefined(CommonAttributes.BORDER_STYLE, CommonStyleAttributes.BORDER_STYLE)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.BORDER_STYLE.getName(), new Integer(this.getBorderAttribute(CommonAttributes.BORDER_STYLE, true, CommonStyleAttributes.BORDER_STYLE)));
        }
        if (this.isAttributeDefined(CommonAttributes.HORIZONTAL_ALIGNMENT, CommonStyleAttributes.HORIZONTAL_ALIGNMENT)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.HORIZONTAL_ALIGNMENT.getName(), new Integer(this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT)));
        }
        if (this.isAttributeDefined(CommonAttributes.VERTICAL_ALIGNMENT, CommonStyleAttributes.VERTICAL_ALIGNMENT)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.VERTICAL_ALIGNMENT.getName(), new Integer(this.getVerticalAlignmentAttribute(CommonAttributes.VERTICAL_ALIGNMENT, true, CommonStyleAttributes.VERTICAL_ALIGNMENT)));
        }
        if (this.isAttributeDefined(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT, CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT.getName(), new Integer(this.getHorizontalAlignmentAttribute(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT)));
        }
        if (this.isAttributeDefined(CommonAttributes.CELL_VERTICAL_ALIGNMENT, CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT.getName(), new Integer(this.getVerticalAlignmentAttribute(CommonAttributes.CELL_VERTICAL_ALIGNMENT, true, CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT)));
        }
        if (this.isAttributeDefined(CommonAttributes.TEXT_RISE, CommonStyleAttributes.TEXT_RISE)) {
            CollectionUtils.put(styleMap, CommonStyleAttributes.TEXT_RISE.getName(), new Float(this.getDimensionAttribute(CommonAttributes.TEXT_RISE, true, CommonStyleAttributes.TEXT_RISE)));
        }
        if ((styleDef = this.getStringAttribute(CommonAttributes.STYLE, true, null)) != null) {
            StyleParser styleParser = this.documentHandler.getStyleParser();
            styleParser.parseStyle(this.locator(), styleDef, this.supportedStyleAttributeMap, styleMap);
        }
        Object value = null;
        AttributeHandler attrHandler = this.documentHandler.getAttributeHandler();
        AttributeDefinitionMap attrDefs = this.buildSupportedStyleAttributes();
        List attrs = attrDefs.getSortedAttributes();
        int numAttrs = attrs.size();
        for (i = 0; i < numAttrs; ++i) {
            attrDef = (AttributeDefinition)attrs.get(i);
            value = this.getStyleAttribute(attrDef.getName());
            if (value == null) continue;
            value = attrHandler.typeCastAttributeValue(this.locator(), attrDef, attrDef.getName(), value);
            CollectionUtils.put(styleMap, attrDef.getName(), value);
        }
        attrDefs = this.buildSupportedAttributes();
        attrs = attrDefs.getSortedAttributes();
        numAttrs = attrs.size();
        for (i = 0; i < numAttrs; ++i) {
            attrDef = (AttributeDefinition)attrs.get(i);
            String attrName = attrDef.getName();
            if ("name".equals(attrName) || "style".equals(attrName) || (value = this.evalAttribute(attrName)) == null) continue;
            value = attrHandler.typeCastAttributeValue(this.locator(), attrDef, attrName, value);
            if ("font".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.FONT_NAME.getName(), value);
                continue;
            }
            if ("bgcolor".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.BACKGROUND_COLOR.getName(), value);
                continue;
            }
            if ("border-style".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.BORDER_STYLE.getName(), value);
                continue;
            }
            if ("border-width".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.BORDER_WIDTH.getName(), value);
                continue;
            }
            if ("border-color".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.BORDER_COLOR.getName(), value);
                continue;
            }
            if ("halign".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.HORIZONTAL_ALIGNMENT.getName(), value);
                continue;
            }
            if ("valign".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.VERTICAL_ALIGNMENT.getName(), value);
                continue;
            }
            if ("cell-halign".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT.getName(), value);
                continue;
            }
            if ("cell-valign".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT.getName(), value);
                continue;
            }
            if ("padding".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.PADDING.getName(), value);
                continue;
            }
            if ("padding-left".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.PADDING_LEFT.getName(), value);
                continue;
            }
            if ("padding-right".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.PADDING_RIGHT.getName(), value);
                continue;
            }
            if ("padding-top".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.PADDING_TOP.getName(), value);
                continue;
            }
            if ("padding-bottom".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.PADDING_BOTTOM.getName(), value);
                continue;
            }
            if ("line-spacing".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.LINE_SPACING.getName(), value);
                continue;
            }
            if ("leading".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.LEADING.getName(), value);
                continue;
            }
            if ("spacing-before".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.SPACING_BEFORE.getName(), value);
                continue;
            }
            if ("spacing-after".equals(attrName)) {
                CollectionUtils.put(styleMap, CommonStyleAttributes.SPACING_AFTER.getName(), value);
                continue;
            }
            if (!"text-rise".equals(attrName)) continue;
            CollectionUtils.put(styleMap, CommonStyleAttributes.TEXT_RISE.getName(), value);
        }
        this.documentHandler.registerStyle(name, styleMap);
    }
}

