/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CaseTag;
import org.ujac.print.tag.DefaultTag;

public class SwitchTag
extends BaseDocumentTag {
    private static final AttributeDefinition VALUE = new AttributeDefinition("value", 4, true, "Expression serving the value to check against the nested case items.");
    public static final String TAG_NAME = "switch";
    private String value = null;
    private boolean matchFound = true;

    public SwitchTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Specifies the value that nested 'case' items compare their value to.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(VALUE);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(CaseTag.class, 1, 999)).addDefinition(new ChildDefinition(DefaultTag.class, 0, 1));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.matchFound = false;
        if (this.isValid()) {
            this.value = this.getStringAttribute(VALUE, true, null);
        }
    }

    public void closeItem() throws DocumentHandlerException {
    }

    public boolean equalsValue(String value) {
        boolean result = this.value.equals(value);
        if (result) {
            this.matchFound = true;
        }
        return result;
    }

    public boolean isMatchFound() {
        return this.matchFound;
    }
}

