/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Table;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CellContainer;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CellTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TocTag;
import org.ujac.util.exi.ExpressionException;

public class TableTag
extends BaseElementTag
implements CellContainer,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "table";
    private CellAttributes cellAttributes = null;
    private Table table = null;
    private int numCells = 0;
    private int columns = 0;
    private float width = 0.0f;
    private String widthsAttr = null;
    private float[] widths = null;
    private int hAlign = 0;

    public TableTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a table to its parent item. Tables are very useful if you want to layout your document nicely.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.TABLE_COLUMNS).addDefinition(CommonAttributes.TABLE_WIDTHS).addDefinition(CommonAttributes.TABLE_WIDTH).addDefinition(CommonAttributes.TABLE_HALIGN);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(TocTag.class, 0, 999)).addDefinition(new ChildDefinition(IndexTag.class, 0, 999)).addDefinition(new ChildDefinition(CellTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseAttributes(this, null);
        this.columns = this.getIntegerAttribute(CommonAttributes.TABLE_COLUMNS, true, null);
        this.widthsAttr = this.getStringAttribute(CommonAttributes.TABLE_WIDTHS, false, null);
        this.width = this.getFloatAttribute(CommonAttributes.TABLE_WIDTH, true, CommonStyleAttributes.TABLE_WIDTH);
        if (this.widthsAttr != null) {
            if (this.columns > 0) {
                throw new TagAttributeException(this.locator(), "Specify eigther widths or columns attribute for tables, not both!");
            }
            StringTokenizer tkn = null;
            try {
                tkn = new StringTokenizer(this.documentHandler.evalString(this.widthsAttr), ",");
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
            this.columns = tkn.countTokens();
            this.widths = new float[this.columns];
            int idx = 0;
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                try {
                    this.widths[idx] = Float.parseFloat(token);
                    ++idx;
                }
                catch (NumberFormatException ex) {
                    throw new TagAttributeException(this.locator(), "Attribute widths must hold a list of floating point numbers, separated by ',' (was '" + token + "').", ex);
                }
            }
        } else {
            this.widths = new float[this.columns];
            float averageWidth = 100.0f / (float)this.columns;
            for (int i = 0; i < this.columns; ++i) {
                this.widths[i] = averageWidth;
            }
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        try {
            this.table = new Table(this.columns);
        }
        catch (BadElementException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to create table: " + ex.getMessage(), ex);
        }
        if (this.width > 0.0f) {
            this.table.setWidth(this.width);
        }
        if (this.widths != null) {
            try {
                this.table.setWidths(this.widths);
            }
            catch (BadElementException ex) {
                throw new DocumentHandlerException(this.locator(), "Invalid table widths: '" + this.getStringAttribute(CommonAttributes.TABLE_WIDTHS, true, null) + "': " + ex.getMessage(), ex);
            }
        }
        this.table.setAlignment(this.hAlign);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.table);
    }

    public void addCell(BaseDocumentTag item, Cell cell) throws DocumentHandlerException {
        this.numCells += Math.max(cell.getColspan(), 1);
        this.table.addCell(cell);
    }

    public int getRemainingColumns() {
        return this.columns - this.numCells % this.columns;
    }

    public Table getTable() {
        return this.table;
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }
}

