/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PagePosition;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.BackgroundImageTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class WatermarkTag
extends BackgroundImageTag
implements ElementContainer,
PhraseHolder,
FontHolder {
    public static final String TAG_NAME = "watermark";
    private static final AttributeDefinition WATERMARK_IMAGE_SOURCE = CommonAttributes.IMAGE_SOURCE.cloneAttrDef().setRequired(false);
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    private Phrase phrase = null;

    public WatermarkTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Inserts a watermark into the document. Watermarks might be images, which  gets loaded by the resource loader, which is specified at the document handler, or are generated from the text, defined by the tag's body.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.FONT).addDefinition(WATERMARK_IMAGE_SOURCE).addDefinition(CommonAttributes.IMAGE_DRAW_FOREGROUND);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.IMAGE_X).addDefinition(CommonStyleAttributes.IMAGE_Y).addDefinition(CommonStyleAttributes.IMAGE_WIDTH).addDefinition(CommonStyleAttributes.IMAGE_HEIGHT).addDefinition(CommonStyleAttributes.SCALE_TO_FIT).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.IMAGE_DRAW_FOREGROUND);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
        super.closeItem();
    }

    public Image getImage() throws DocumentHandlerException {
        if (this.sourceAttr != null) {
            return super.getImage();
        }
        if (this.phrase == null) {
            throw new DocumentHandlerException(this.locator(), "The watermark tag requires eighter a image source definition or a watermark text, defined by the tag body.");
        }
        try {
            PdfContentByte cb = ((PdfWriter)this.documentHandler.getDocumentWriter(true)).getDirectContent();
            float phraseWidth = this.getPhraseWidth(this.phrase);
            float phraseHeight = this.getPhraseHeight(this.phrase);
            PdfTemplate template = cb.createTemplate(phraseWidth, phraseHeight);
            template.beginText();
            this.printPhrase(template, this.phrase, 0.0f, phraseHeight * 0.25f);
            template.endText();
            Image img = Image.getInstance((PdfTemplate)template);
            return img;
        }
        catch (BadElementException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to rotate phrase: " + ex.getMessage(), ex);
        }
    }

    protected void insertImage(PdfWriter writer, Document document, Image image) {
        try {
            Rectangle pageSize = document.getPageSize();
            PagePosition pos = this.getPosition();
            float x = pos.calcX(pageSize.getRight(), image.getScaledWidth());
            float y = pos.calcY(pageSize.getTop(), image.getScaledHeight());
            image.setAbsolutePosition(x, y);
            boolean drawForeground = this.getBooleanAttribute(CommonAttributes.IMAGE_DRAW_FOREGROUND, false, true, CommonStyleAttributes.IMAGE_DRAW_FOREGROUND);
            PdfContentByte cb = null;
            cb = drawForeground ? writer.getDirectContent() : writer.getDirectContentUnder();
            cb.addImage(image);
        }
        catch (DocumentException ex) {
            this.log.error((Object)("Watermark output failed: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        catch (DocumentHandlerException ex) {
            this.log.error((Object)("Watermark output failed: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public String getActualContent() {
        if (this.phrase == null) {
            return super.getActualContent();
        }
        return this.getPhraseContent(this.phrase);
    }

    public void flushContent() throws DocumentHandlerException {
        Phrase nestedPhrase;
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.createPhrase();
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if ((nestedPhrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing())) != null) {
            this.phrase = nestedPhrase;
        }
        this.resetContent();
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (this.phrase == null) {
            this.createPhrase();
        }
        this.phrase.add((Object)element);
        if (element instanceof Phrase) {
            this.extendLeading(this.phrase, (Phrase)element);
        }
    }

    public boolean isTopLevel() {
        return false;
    }

    private void createPhrase() {
        this.phrase = new Phrase(0.0f);
    }
}

