/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RadioCheckField;
import java.io.IOException;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.util.template.TemplateException;

public class CheckBoxAcroFieldTag
extends BaseAcroFieldTag {
    public static final String TAG_NAME = "check-box";
    protected String fieldValue = null;
    protected boolean status = false;

    public CheckBoxAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a check box to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(FIELD_VALUE).addDefinition(FIELD_STATUS).addDefinition(CommonAttributes.FONT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
        this.status = this.getBooleanAttribute(FIELD_STATUS, true, null);
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            PdfWriter pdfWriter = this.getPdfWriter();
            RadioCheckField cf = new RadioCheckField(pdfWriter, this.getFieldDimensions(), this.fieldName, this.fieldValue);
            cf.setChecked(this.status);
            cf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            cf.setRotation(rotation);
            cf.setFontSize(font.getSize());
            cf.setBorderStyle(this.getBorderType());
            cf.setBorderWidth(this.getBorderWidth());
            cf.setBorderColor(this.getBorderColor());
            cf.setBackgroundColor(this.getBackgroundColor());
            cf.setTextColor(this.getTextColor());
            cf.setOptions(0);
            cf.setCheckType(1);
            PdfFormField ff = cf.getCheckField();
            this.applyJavaScript(ff);
            return ff;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    public PdfFormField render(PdfWriter writer, Rectangle fieldPosition) throws DocumentHandlerException {
        PdfFormField formField = super.render(writer, fieldPosition);
        String label = null;
        try {
            label = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        DocumentFont docFont = this.getFont();
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        cb.beginText();
        cb.setFontAndSize(docFont.getFont().getBaseFont(), docFont.getSize());
        float x = this.x;
        float y = this.y;
        if (fieldPosition != null) {
            x = fieldPosition.getLeft();
            y = fieldPosition.getBottom();
        }
        cb.moveText(x + this.width * 1.2f, y + this.borderWidth);
        cb.showText(label);
        cb.endText();
        cb.restoreState();
        return formField;
    }
}

