/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.acroform.Option;
import org.ujac.print.tag.acroform.OptionHolder;
import org.ujac.util.template.TemplateException;

public class OptionTag
extends BaseDocumentTag {
    private static final AttributeDefinition VALUE = new AttributeDefinition("value", 12, false, "The option value.");
    public static final String TAG_NAME = "option";
    private OptionHolder optionHolder = null;

    public OptionTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds options to the surrounding option holder. Known item holders tags are: combo-box and select-list.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(VALUE);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.optionHolder = (OptionHolder)((Object)this.documentHandler.latestOfType(OptionHolder.class));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String text = null;
        try {
            text = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        String value = this.getStringAttribute(VALUE, text, false, null);
        this.optionHolder.addOption(new Option(value, text));
    }
}

