/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;
import org.ujac.print.tag.graphics.PointHolder;
import org.ujac.print.tag.graphics.PointTag;

public class DrawPolygonTag
extends BaseGraphicsTag
implements PointHolder {
    public static final String TAG_NAME = "draw-polygon";
    private static final AttributeDefinition POLYGON_FILL = FILL.cloneAttrDef("Tells whether or not to fill the polygon, default is false.");
    private int numPoints = 0;

    public DrawPolygonTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a polygon.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(POLYGON_FILL);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(PointTag.class, 0, 999));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.numPoints = 0;
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        boolean fill = this.getBooleanAttribute(FILL, false, true, null);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        if (fill) {
            cb.closePathFillStroke();
        } else {
            cb.closePathStroke();
        }
    }

    public void addPoint(float x, float y) throws TagAttributeException {
        PdfContentByte cb = this.graphicsTag.getContentByte();
        if (this.numPoints == 0) {
            cb.moveTo(x, y);
        } else {
            cb.lineTo(x, y);
        }
        ++this.numPoints;
    }
}

