/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;
import org.ujac.print.tag.graphics.PointHolder;

public class PointTag
extends BaseGraphicsTag {
    public static final String TAG_NAME = "point";
    private PointHolder pointHolder = null;

    public PointTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a single point for a polygon or poly line.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(X).addDefinition(Y);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.pointHolder = (PointHolder)((Object)this.documentHandler.latestOfType(PointHolder.class));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float x = this.getDimensionAttribute(X, true, X);
        float y = this.getDimensionAttribute(Y, true, Y);
        this.pointHolder.addPoint(x, y);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

