/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class SetLineDashTag
extends BaseGraphicsTag {
    protected static final AttributeDefinition PHASE = new AttributeDefinition("phase", 14, true, "The value of the phase.");
    protected static final AttributeDefinition UNITS_ON = new AttributeDefinition("units-on", 14, false, "The number of units that must be on.");
    protected static final AttributeDefinition UNITS_OFF = new AttributeDefinition("units-off", 14, false, "The number of units that must be off.");
    public static final String TAG_NAME = "set-line-dash";

    public SetLineDashTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the current line dash for the surrounding graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(PHASE).addDefinition(UNITS_ON).addDefinition(UNITS_OFF);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float phase = this.getDimensionAttribute(PHASE, true, null);
        float unitsOn = this.getDimensionAttribute(UNITS_ON, 0.0f, true, (AttributeDefinition)null);
        float unitsOff = this.getDimensionAttribute(UNITS_OFF, 0.0f, true, (AttributeDefinition)null);
        this.graphicsTag.setLineDash(phase, unitsOn, unitsOff);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

