/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class SetLineWidthTag
extends BaseGraphicsTag {
    protected static final AttributeDefinition WIDTH = new AttributeDefinition("width", 14, true, "The line width to set.");
    public static final String TAG_NAME = "set-line-width";

    public SetLineWidthTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the current line dash for the surrounding graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(WIDTH);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        float width = this.getDimensionAttribute(WIDTH, true, null);
        this.graphicsTag.setLineWidth(width);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

