/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.ujac.util.db.AttributeDefinition;
import org.ujac.util.db.DataTypeMapper;
import org.ujac.util.db.DefaultDataTypeMapper;
import org.ujac.util.db.TableDefinition;

public class DatabaseSchemaReader {
    private Connection cxn = null;
    private String driver;
    private String url;
    private String user;
    private String passwd;
    private DataTypeMapper dataTypeMapper = null;

    public DatabaseSchemaReader(Connection cxn) {
        this(cxn, new DefaultDataTypeMapper());
    }

    public DatabaseSchemaReader(Connection cxn, DataTypeMapper dataTypeMapper) {
        this.cxn = cxn;
        this.dataTypeMapper = dataTypeMapper;
    }

    public DatabaseSchemaReader(String driver, String url, String user, String passwd) {
        this(driver, url, user, passwd, new DefaultDataTypeMapper());
    }

    public DatabaseSchemaReader(String driver, String url, String user, String passwd, DataTypeMapper dataTypeMapper) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.dataTypeMapper = dataTypeMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableDefinition getTableDefinition(String tableName) throws SQLException {
        TableDefinition tableDef = new TableDefinition(tableName);
        boolean maintainConnection = false;
        if (this.cxn == null) {
            maintainConnection = true;
            this.cxn = this.getConnection();
        }
        try {
            DatabaseMetaData meta = this.cxn.getMetaData();
            String catalog = this.cxn.getCatalog();
            HashSet<String> primaryKeySet = new HashSet<String>();
            ResultSet primaryKeys = meta.getPrimaryKeys(catalog, tableDef.getSchema(), tableDef.getName());
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString(4);
                primaryKeySet.add(columnName);
            }
            primaryKeys.close();
            HashSet<String> foreignKeySet = new HashSet<String>();
            ResultSet foreignKeys = meta.getImportedKeys(catalog, tableDef.getSchema(), tableDef.getName());
            while (foreignKeys.next()) {
                String columnName = foreignKeys.getString(8);
                foreignKeySet.add(columnName);
            }
            foreignKeys.close();
            ResultSet columns = meta.getColumns(catalog, tableDef.getSchema(), tableDef.getName(), "%");
            while (columns.next()) {
                String columnName = columns.getString(4);
                int columnType = columns.getInt(5);
                int columnSize = columns.getInt(7);
                int decimalDigits = columns.getInt(9);
                String javaName = DatabaseSchemaReader.getJavaName(columnName);
                tableDef.addAttribute(new AttributeDefinition(javaName, columnName, columnType, columnSize, decimalDigits, primaryKeySet.contains(columnName), foreignKeySet.contains(columnName), this.dataTypeMapper));
            }
            columns.close();
        }
        finally {
            if (maintainConnection) {
                this.cleanup(this.cxn);
                this.cxn = null;
            }
        }
        return tableDef;
    }

    public static final String getJavaName(String columnName) {
        StringTokenizer tkn = new StringTokenizer(columnName.toLowerCase(), "_", true);
        StringBuffer nameBuf = new StringBuffer();
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (token.charAt(0) == '_') {
                if (!tkn.hasMoreTokens()) continue;
                token = tkn.nextToken();
                if (nameBuf.length() > 0) {
                    nameBuf.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
                    continue;
                }
                nameBuf.append(token);
                continue;
            }
            nameBuf.append(token);
        }
        return nameBuf.toString();
    }

    private Connection getConnection() throws SQLException {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("The driver class '" + this.driver + "' could not be found in the class path.");
        }
        return DriverManager.getConnection(this.url, this.user, this.passwd);
    }

    private void cleanup(Connection cxn) {
        try {
            if (cxn != null) {
                cxn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: org.ujac.util.codegen.DatabaseSchemaReader <driver> <url> <user> <passwd> <table name>");
            System.exit(1);
        }
        String driver = args[0];
        String url = args[1];
        String user = args[2];
        String passwd = args[3];
        String tableName = args[4];
        DatabaseSchemaReader reader = new DatabaseSchemaReader(driver, url, user, passwd);
        try {
            TableDefinition tableDef = reader.getTableDefinition(tableName);
            System.out.println(tableDef);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

