/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ujac.util.text.FormatHelper;

public class ExpressionContext
implements Map,
Serializable {
    private static final long serialVersionUID = 3546084661601252665L;
    private Map properties;
    private Object bean;
    private FormatHelper formatHelper;

    public ExpressionContext() {
        this(new HashMap(), null, null);
    }

    public ExpressionContext(Map properties) {
        this(properties, null, null);
    }

    public ExpressionContext(Map properties, FormatHelper formatHelper) {
        this(properties, null, formatHelper);
    }

    public ExpressionContext(Map properties, Object bean, FormatHelper formatHelper) {
        this.properties = properties;
        this.bean = bean;
        this.formatHelper = formatHelper == null ? FormatHelper.createInstance() : formatHelper;
    }

    public ExpressionContext(ExpressionContext ctx) {
        this.properties = new HashMap(ctx.properties);
        this.bean = ctx.getBean();
        this.formatHelper = ctx.getFormatHelper();
    }

    public Object getProperty(Object name) {
        return this.properties.get(name);
    }

    public Object setProperty(Object name, Object value) {
        return this.properties.put(name, value);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.formatHelper = formatHelper;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Object get(Object key) {
        return this.getProperty(key);
    }

    public Object put(Object key, Object value) {
        return this.setProperty(key, value);
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public void putAll(Map properties) {
        if (properties == null) {
            return;
        }
        Iterator iterProperties = properties.entrySet().iterator();
        while (iterProperties.hasNext()) {
            Map.Entry entry = iterProperties.next();
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Collection values() {
        return this.properties.values();
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        s.writeObject(this.properties);
        s.writeObject(this.bean);
        s.writeObject(this.formatHelper);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.properties = (Map)s.readObject();
        this.bean = s.readObject();
        this.formatHelper = (FormatHelper)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

