/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.ujac.util.BeanException;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.ConstantOperand;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.ExpressionType;
import org.ujac.util.exi.NullType;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.Operation;
import org.ujac.util.exi.SequenceIndex;
import org.ujac.util.exi.VariableOperand;
import org.ujac.util.exi.type.BaseNumberType;
import org.ujac.util.exi.type.BooleanType;
import org.ujac.util.exi.type.ByteArrayType;
import org.ujac.util.exi.type.ByteType;
import org.ujac.util.exi.type.CharArrayType;
import org.ujac.util.exi.type.CharType;
import org.ujac.util.exi.type.CollectionType;
import org.ujac.util.exi.type.ConditionResultHolderType;
import org.ujac.util.exi.type.DateType;
import org.ujac.util.exi.type.DefaultType;
import org.ujac.util.exi.type.DoubleArrayType;
import org.ujac.util.exi.type.DoubleType;
import org.ujac.util.exi.type.FloatArrayType;
import org.ujac.util.exi.type.FloatType;
import org.ujac.util.exi.type.IntArrayType;
import org.ujac.util.exi.type.IntegerType;
import org.ujac.util.exi.type.LongArrayType;
import org.ujac.util.exi.type.LongType;
import org.ujac.util.exi.type.MapEntryType;
import org.ujac.util.exi.type.MapType;
import org.ujac.util.exi.type.NullValueType;
import org.ujac.util.exi.type.ObjectArrayType;
import org.ujac.util.exi.type.ResourceBundleType;
import org.ujac.util.exi.type.RowType;
import org.ujac.util.exi.type.ShortArrayType;
import org.ujac.util.exi.type.ShortType;
import org.ujac.util.exi.type.StringType;
import org.ujac.util.exi.type.TableType;
import org.ujac.util.exi.type.TimeType;
import org.ujac.util.exi.type.TimestampType;
import org.ujac.util.text.FormatHelper;

public class ExpressionInterpreter
implements Cloneable {
    public static final String ATTRIBUTE_NAME = "org.ujac.expression.interpreter";
    public static final int PS_OBJECT = 1;
    public static final int PS_OPERATION = 2;
    public static final int PS_OPERAND = 3;
    public static final Class DEFAULT_TYPE = Object.class;
    public static final Class NULL_VALUE_TYPE = NullType.class;
    public static final Class[] GETTER_ARG_TYPES = new Class[0];
    public static final Object[] GETTER_ARGS = new Object[0];
    private DateFormat intDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat intTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private DateFormat intTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ExpressionInterpreter prototype = new ExpressionInterpreter();
    private Map typeHandlers = new HashMap();
    private Map typeNameMap = new HashMap();
    private static final Map operationPriorityMap = new HashMap();

    public static ExpressionInterpreter createInstance() {
        if (prototype == null) {
            String clazzName = System.getProperty(ATTRIBUTE_NAME);
            if (clazzName != null) {
                try {
                    prototype = (ExpressionInterpreter)Class.forName(clazzName).newInstance();
                    return prototype;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to create ExpressionInterpreter instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException("Unable to create ExpressionInterpreter instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Unable to create ExpressionInterpreter instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException("Unable to create ExpressionInterpreter instance from class '" + clazzName + "': " + ex.getMessage());
                }
            }
            return new ExpressionInterpreter();
        }
        return (ExpressionInterpreter)prototype.clone();
    }

    public static void setPrototype(ExpressionInterpreter prototype) {
        ExpressionInterpreter.prototype = prototype;
    }

    public ExpressionInterpreter() {
        this.registerDefaultTypeHandlers();
    }

    public void registerTypeHandler(ExpressionType type) {
        this.registerTypeHandler(type.getType(), type);
    }

    public void registerTypeHandler(Class typeClass, ExpressionType type) {
        this.typeHandlers.put(typeClass, type);
        this.typeNameMap.put(typeClass.getName(), type);
        String alias = type.getAlias();
        if (alias != null) {
            this.typeNameMap.put(alias, type);
        }
    }

    public void unregisterTypeHandler(ExpressionType type) {
        this.unregisterTypeHandler(type.getType());
    }

    public void unregisterTypeHandler(Class typeClass) {
        this.typeHandlers.remove(typeClass);
    }

    public void unregisterAllTypeHandlers() {
        this.typeHandlers.clear();
    }

    public void registerDefaultTypeHandlers() {
        this.registerTypeHandler(new DefaultType(this));
        this.registerTypeHandler(new NullValueType(this));
        this.registerTypeHandler(new BooleanType(this));
        this.registerTypeHandler(new ConditionResultHolderType(this));
        this.registerTypeHandler(new DateType(this));
        this.registerTypeHandler(new TimeType(this));
        this.registerTypeHandler(new TimestampType(this));
        this.registerTypeHandler(new DoubleType(this, Double.class, "double"));
        this.registerTypeHandler(new FloatType(this));
        this.registerTypeHandler(BigDecimal.class, new DoubleType(this, BigDecimal.class, "BigDecimal"));
        this.registerTypeHandler(new IntegerType(this, Integer.class, "int"));
        this.registerTypeHandler(SequenceIndex.class, new IntegerType(this, SequenceIndex.class, null));
        this.registerTypeHandler(new ShortType(this));
        this.registerTypeHandler(new ByteType(this));
        this.registerTypeHandler(new LongType(this));
        this.registerTypeHandler(new StringType(this));
        this.registerTypeHandler(new CharType(this));
        this.registerTypeHandler(new TableType(this));
        this.registerTypeHandler(new RowType(this));
        this.registerTypeHandler(new CollectionType(this));
        this.registerTypeHandler(new MapType(this));
        this.registerTypeHandler(new MapEntryType(this));
        this.registerTypeHandler(new ResourceBundleType(this));
        this.registerTypeHandler(new ObjectArrayType(this));
        this.registerTypeHandler(new ShortArrayType(this));
        this.registerTypeHandler(new IntArrayType(this));
        this.registerTypeHandler(new LongArrayType(this));
        this.registerTypeHandler(new FloatArrayType(this));
        this.registerTypeHandler(new DoubleArrayType(this));
        this.registerTypeHandler(new CharArrayType(this));
        this.registerTypeHandler(new ByteArrayType(this));
    }

    public Object getParameterValue(String paramName, ExpressionContext ctx) throws ExpressionException {
        Object value = ctx.getProperty(paramName);
        if (value != null) {
            return value;
        }
        Object bean = ctx.getBean();
        if (bean == null) {
            return null;
        }
        if (paramName == null) {
            return null;
        }
        try {
            value = BeanUtils.getProperty(bean, paramName, true);
            ctx.setProperty(paramName, value);
        }
        catch (BeanException ex) {
            throw new ExpressionException("Property '" + paramName + "' could not be evaluated for given bean from class " + bean.getClass().getName() + ".", ex);
        }
        return value;
    }

    public String getConstantValue(String constant) throws ExpressionException {
        int length = constant.length();
        if (constant.charAt(0) == '\'') {
            if (constant.charAt(length - 1) != '\'') {
                throw new ExpressionException("Syntax error in constant definition at token '" + constant + "'.");
            }
            return constant.substring(1, length - 1);
        }
        if (constant.charAt(0) == '\"') {
            if (constant.charAt(length - 1) != '\"') {
                throw new ExpressionException("Syntax error in constant definition at token '" + constant + "'.");
            }
            return constant.substring(1, length - 1);
        }
        return constant;
    }

    public String evalString(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalString(text, params, null, formatHelper);
    }

    public String evalString(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return "";
        }
        return this.evalString(text, new ExpressionContext(params, bean, formatHelper));
    }

    public String evalString(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return "";
        }
        Object result = this.evalObject(text, ctx);
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    public boolean evalBoolean(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalBoolean(text, params, null, formatHelper);
    }

    public boolean evalBoolean(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return false;
        }
        return this.evalBoolean(text, new ExpressionContext(params, bean, formatHelper));
    }

    public boolean evalBoolean(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return false;
        }
        Object result = this.evalObject(text, ctx);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return new Boolean(result.toString());
    }

    public Date evalDate(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalDate(text, params, null, formatHelper);
    }

    public Date evalDate(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return null;
        }
        return this.evalDate(text, new ExpressionContext(params, bean, formatHelper));
    }

    public Date evalDate(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return null;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Date) {
            return (Date)result;
        }
        try {
            return this.intDateFormat.parse(text);
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a date value.");
        }
    }

    public Time evalTime(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalTime(text, params, null, formatHelper);
    }

    public Time evalTime(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return null;
        }
        return this.evalTime(text, new ExpressionContext(params, bean, formatHelper));
    }

    public Time evalTime(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return null;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Time) {
            return (Time)result;
        }
        if (result instanceof Date) {
            return new Time(((Date)result).getTime());
        }
        try {
            return new Time(this.intTimeFormat.parse(text).getTime());
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a time value.");
        }
    }

    public Timestamp evalTimestamp(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalTimestamp(text, params, null, formatHelper);
    }

    public Timestamp evalTimestamp(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return null;
        }
        return this.evalTimestamp(text, new ExpressionContext(params, bean, formatHelper));
    }

    public Timestamp evalTimestamp(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return null;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Timestamp) {
            return (Timestamp)result;
        }
        if (result instanceof Date) {
            return new Timestamp(((Date)result).getTime());
        }
        try {
            return new Timestamp(this.intTimestampFormat.parse(text).getTime());
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a timestamp value.");
        }
    }

    public int evalInt(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalInt(text, params, null, formatHelper);
    }

    public int evalInt(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return 0;
        }
        return this.evalInt(text, new ExpressionContext(params, bean, formatHelper));
    }

    public int evalInt(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return 0;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        try {
            if (result == null) {
                return 0;
            }
            return new Integer(result.toString());
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a integer value.");
        }
    }

    public long evalLong(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalLong(text, params, null, formatHelper);
    }

    public long evalLong(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return 0L;
        }
        return this.evalLong(text, new ExpressionContext(params, bean, formatHelper));
    }

    public long evalLong(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return 0L;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        try {
            if (result == null) {
                return 0L;
            }
            return new Long(result.toString());
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a long value.");
        }
    }

    public double evalDouble(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalDouble(text, params, null, formatHelper);
    }

    public double evalDouble(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return 0.0;
        }
        return this.evalDouble(text, new ExpressionContext(params, bean, formatHelper));
    }

    public double evalDouble(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return 0.0;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        try {
            if (result == null) {
                return 0.0;
            }
            return new Double(result.toString());
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a double value.");
        }
    }

    public float evalFloat(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalFloat(text, params, null, formatHelper);
    }

    public float evalFloat(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return 0.0f;
        }
        return this.evalFloat(text, new ExpressionContext(params, bean, formatHelper));
    }

    public float evalFloat(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return 0.0f;
        }
        Object result = this.evalObject(text, ctx);
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        try {
            if (result == null) {
                return 0.0f;
            }
            return new Float(result.toString()).floatValue();
        }
        catch (Exception ex) {
            throw new ExpressionException("Unable to evaluate code '" + text + "' as a float value.");
        }
    }

    public Object evalObject(String text, Map params, FormatHelper formatHelper) throws ExpressionException {
        return this.evalObject(text, params, null, formatHelper);
    }

    public Object evalObject(String text, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        if (text == null) {
            return null;
        }
        return this.evalObject(text, new ExpressionContext(params, bean, formatHelper));
    }

    public Object evalObject(String text, ExpressionContext ctx) throws ExpressionException {
        if (text == null) {
            return null;
        }
        ExpressionTuple expression = this.parseExpr(text);
        if (expression == null) {
            return text;
        }
        return this.evalExpr(expression, ctx);
    }

    public ExpressionTuple parseExpr(String expression) throws ExpressionException {
        return this.parseExpr(expression.toCharArray(), 0, expression.length() - 1);
    }

    public ExpressionTuple parseExpr(char[] expression, int offset, int lastPos) throws ExpressionException {
        ExpressionTuple expressionTuple = this.scanExpression(expression, offset, lastPos);
        if (expressionTuple == null) {
            return null;
        }
        ExpressionTuple rootExpression = expressionTuple;
        int absolutePosition = expressionTuple.getAbsolutePosition();
        int length = expressionTuple.getLength();
        int endPos = absolutePosition + length - 1;
        while (absolutePosition <= endPos) {
            ExpressionTuple objectExpr;
            if (expressionTuple.getObject() == null) {
                absolutePosition = this.parseOperand(expressionTuple, 1, absolutePosition);
            } else {
                ExpressionTuple objectExpression = new ExpressionTuple(expressionTuple);
                objectExpression.setAbsolutePosition(absolutePosition);
                objectExpression.setRelativePosition(absolutePosition - expressionTuple.getAbsolutePosition());
                objectExpression.setLength(expressionTuple.getLength() - (absolutePosition - expressionTuple.getAbsolutePosition()));
                objectExpression.setObject(expressionTuple.getObject());
                objectExpression.setOperand(expressionTuple.getOperand());
                objectExpression.setOperation(expressionTuple.getOperation());
                expressionTuple.setObject(objectExpression);
                expressionTuple.setOperand(null);
                expressionTuple.setOperation(null);
            }
            if (absolutePosition > endPos) {
                return rootExpression;
            }
            if ((absolutePosition = this.parseOperation(expressionTuple, absolutePosition)) > endPos) {
                return rootExpression;
            }
            if (expressionTuple.getOperation() == null) {
                return rootExpression;
            }
            Operand object = expressionTuple.getObject();
            if (!object.isSimple() && (objectExpr = (ExpressionTuple)object).getOperation() != null && !objectExpr.isExplitelyEncapsulated() && objectExpr.getOperation().getPriority() < expressionTuple.getOperation().getPriority()) {
                ExpressionTuple operandExpr = new ExpressionTuple(rootExpression);
                operandExpr.setAbsolutePosition(absolutePosition);
                operandExpr.setRelativePosition(absolutePosition - rootExpression.getAbsolutePosition());
                operandExpr.setLength(expressionTuple.getLength() - (absolutePosition - expressionTuple.getAbsolutePosition()));
                operandExpr.setObject(objectExpr.getOperand());
                operandExpr.setOperation(expressionTuple.getOperation());
                expressionTuple.setOperand(operandExpr);
                expressionTuple.setObject(objectExpr.getObject());
                expressionTuple.setOperation(objectExpr.getOperation());
                expressionTuple = operandExpr;
            }
            if ((absolutePosition = this.parseOperand(expressionTuple, 3, absolutePosition)) <= endPos) continue;
            return rootExpression;
        }
        return rootExpression;
    }

    private int parseOperation(ExpressionTuple expressionTuple, int position) throws ExpressionException {
        int i;
        int operationStart = -1;
        char[] source = expressionTuple.getSource();
        int lastPos = expressionTuple.getAbsolutePosition() + expressionTuple.getLength() - 1;
        block11: for (i = position; i <= lastPos; ++i) {
            char c = source[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    if (operationStart == -1) continue block11;
                    expressionTuple.setOperation(ExpressionInterpreter.checkOperation(new String(source, operationStart, i - operationStart)));
                    return i + 1;
                }
                case '$': {
                    if (operationStart != -1) {
                        expressionTuple.setOperation(ExpressionInterpreter.checkOperation(new String(source, operationStart, i - operationStart)));
                        return i;
                    }
                    return position;
                }
                case '.': {
                    expressionTuple.setOperation(new Operation(new String(source, i, 1), 10));
                    return i + 1;
                }
                case '[': {
                    expressionTuple.setOperation(new Operation("[]", 10));
                    return i + 1;
                }
                case '%': 
                case '*': 
                case '/': {
                    expressionTuple.setOperation(new Operation(new String(source, i, 1), 9));
                    return i + 1;
                }
                case '+': 
                case '-': {
                    expressionTuple.setOperation(new Operation(new String(source, i, 1), 8));
                    return i + 1;
                }
                case '!': 
                case '<': 
                case '>': {
                    if (operationStart == -1) {
                        operationStart = i;
                    }
                    char oc = c;
                    if ((c = source[++i]) != '=') {
                        if (oc == '!') {
                            throw new ExpressionException("The operation '!" + c + "' is undefined at expression '" + new String(source, expressionTuple.getAbsolutePosition(), expressionTuple.getLength()) + "'");
                        }
                        expressionTuple.setOperation(new Operation(new String(source, operationStart, i - operationStart), 6));
                        return i;
                    }
                }
                case '=': {
                    if (operationStart == -1) {
                        operationStart = i;
                    }
                    if (i - operationStart < 1) continue block11;
                    expressionTuple.setOperation(new Operation(new String(source, operationStart, i - operationStart + 1), 6));
                    return i + 1;
                }
                case ':': 
                case '?': {
                    expressionTuple.setOperation(new Operation(new String(source, i, 1), 5));
                    return i + 1;
                }
                default: {
                    if (operationStart != -1) continue block11;
                    operationStart = i;
                }
            }
        }
        if (operationStart != -1) {
            expressionTuple.setOperation(ExpressionInterpreter.checkOperation(new String(source, operationStart, i - operationStart)));
            return i + 1;
        }
        return position;
    }

    private static final Operation checkOperation(String name) {
        Integer priority = (Integer)operationPriorityMap.get(name);
        int p = 7;
        if (priority != null) {
            p = priority;
        }
        return new Operation(name, p);
    }

    private int parseOperand(ExpressionTuple expressionTuple, int parseState, int position) throws ExpressionException {
        int i;
        Operation operation = expressionTuple.getOperation();
        char[] source = expressionTuple.getSource();
        int lastPos = expressionTuple.getAbsolutePosition() + expressionTuple.getLength() - 1;
        if (parseState == 3 && operation.getName().charAt(0) == '[') {
            int level = 0;
            int constantStart = -1;
            int constantEnd = -1;
            int valueStart = -1;
            int valueEnd = -1;
            char constantQuotationMark = '\u0000';
            boolean parseExpr = false;
            block6: for (i = position; i <= lastPos; ++i) {
                char c = source[i];
                switch (c) {
                    case '$': {
                        if (i >= lastPos || source[i + 1] != '{') continue block6;
                        ++level;
                        parseExpr = true;
                        continue block6;
                    }
                    case '}': {
                        --level;
                        continue block6;
                    }
                    case '\"': 
                    case '\'': {
                        if (level == 0 && constantEnd < 0) {
                            if (constantStart >= 0) continue block6;
                            constantStart = i + 1;
                            ++i;
                            while (i <= lastPos) {
                                char nc = source[i];
                                if (nc == c) {
                                    constantQuotationMark = nc;
                                    constantEnd = i - 1;
                                    continue block6;
                                }
                                ++i;
                            }
                            continue block6;
                        }
                        constantEnd = i;
                        continue block6;
                    }
                    case ']': {
                        if (level == 0) {
                            if (parseExpr) {
                                ExpressionTuple nested = this.parseExpr(source, position, i);
                                nested.setExplitelyEncapsulated(true);
                                expressionTuple.setOperand(nested);
                                return i + 1;
                            }
                            if (constantEnd >= 0) {
                                ConstantOperand operand = new ConstantOperand(source, constantStart, constantStart - position, constantEnd - constantStart + 1);
                                if (constantQuotationMark != '\u0000') {
                                    operand.setTotalPosition(constantStart - 1);
                                    operand.setTotalLength(operand.getLength() + 2);
                                }
                                expressionTuple.setOperand(operand);
                                return i + 1;
                            }
                            if (valueEnd >= 0) {
                                if (Character.isDigit(source[valueStart])) {
                                    ConstantOperand constant = new ConstantOperand(expressionTuple);
                                    int valueLength = valueEnd - valueStart + 1;
                                    constant.setObject(this.parseNumber(new String(source, valueStart, valueLength)));
                                    constant.setAbsolutePosition(valueStart);
                                    constant.setRelativePosition(valueStart - position);
                                    constant.setLength(valueLength);
                                    expressionTuple.setOperand(constant);
                                    return i + 1;
                                }
                                VariableOperand variable = new VariableOperand(expressionTuple);
                                int valueLength = valueEnd - valueStart + 1;
                                variable.setVariable(new String(source, valueStart, valueLength));
                                variable.setAbsolutePosition(valueStart);
                                variable.setRelativePosition(valueStart - position);
                                variable.setLength(valueLength);
                                expressionTuple.setOperand(variable);
                                return i + 1;
                            }
                            ConstantOperand operand = new ConstantOperand(source, valueStart, valueStart - position, valueEnd - valueStart);
                            expressionTuple.setOperand(operand);
                            return i + 1;
                        }
                    }
                    default: {
                        if (Character.isWhitespace(c)) continue block6;
                        if (valueStart == -1) {
                            valueStart = i;
                            valueEnd = i;
                            continue block6;
                        }
                        valueEnd = i;
                    }
                }
            }
            throw new ExpressionException("Missing closing bracket in  source '" + new String(source) + "'.");
        }
        boolean forceConstant = operation != null && operation.getName().charAt(0) == '.';
        Operand operand = this.parseOperand(source, i, lastPos, forceConstant);
        if (operand == null) {
            return i;
        }
        if (parseState == 1) {
            expressionTuple.setObject(operand);
        } else {
            expressionTuple.setOperand(operand);
        }
        return operand.getTotalPosition() + operand.getTotalLength();
    }

    public Operand parseOperand(char[] source, int position, int lastPos, boolean forceConstant) throws ExpressionException {
        int i;
        int operandStart = -1;
        ExpressionType castType = null;
        boolean signedNegative = false;
        boolean numericConstant = false;
        block8: for (i = position; i <= lastPos; ++i) {
            char c = source[i];
            switch (c) {
                case '(': {
                    int castTypeStart = i + 1;
                    while (i <= lastPos) {
                        char nc = source[i];
                        if (nc == ')') {
                            String typeName = new String(source, castTypeStart, i - castTypeStart);
                            castType = this.getTypeByName(typeName);
                            continue block8;
                        }
                        ++i;
                    }
                    throw new ExpressionException("Detected unterminated type cast position " + castTypeStart + " in  source '" + new String(source) + "'.");
                }
                case '$': {
                    if (i < lastPos) {
                        if (source[i + 1] == '{') {
                            ExpressionTuple nested = this.parseExpr(source, i, lastPos);
                            nested.setExplitelyEncapsulated(true);
                            return nested;
                        }
                        throw new ExpressionException("Detected problem at position " + i + " in  source '" + new String(source) + "'.");
                    }
                }
                case '-': {
                    if (operandStart < 0 && !signedNegative) {
                        signedNegative = true;
                        continue block8;
                    }
                }
                case '!': 
                case '*': 
                case '+': 
                case '.': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': {
                    if (operandStart != -1 && c == '.' && numericConstant) continue block8;
                    --i;
                    break block8;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (operandStart == -1) continue block8;
                    --i;
                    break block8;
                }
                case '\"': 
                case '\'': {
                    if (operandStart != -1) {
                        throw new ExpressionException("Syntax error in expression: Syntax error at constant at position " + i + " while parsing expression '" + new String(source) + "'.");
                    }
                    operandStart = ++i;
                    while (i <= lastPos) {
                        char nc = source[i];
                        if (nc == c) {
                            ConstantOperand operand = new ConstantOperand(source, operandStart, operandStart - position, i - operandStart);
                            operand.setForcedType(castType);
                            operand.setObject(new String(source, operandStart, i - operandStart));
                            operand.setTotalPosition(operandStart - 1);
                            operand.setLength(i - operandStart);
                            operand.setTotalLength(operand.getLength() + 2);
                            return operand;
                        }
                        ++i;
                    }
                    throw new ExpressionException("Syntax error in expression:Unexpected end of expression at position " + i + " while parsing expression '" + new String(source) + "'.");
                }
                default: {
                    if (operandStart != -1) continue block8;
                    numericConstant = Character.isDigit(source[i]);
                    operandStart = i > position && numericConstant && source[i - 1] == '-' ? i - 1 : i;
                }
            }
        }
        if (operandStart == -1) {
            return null;
        }
        if (i > lastPos) {
            i = lastPos;
        }
        int operandLength = i - operandStart + 1;
        String operand = new String(source, operandStart, operandLength);
        if (numericConstant) {
            ConstantOperand constant = new ConstantOperand(source, operandStart, operandStart - position, operandLength);
            Object constantValue = this.parseNumber(operand);
            if (castType != null) {
                constantValue = castType.typeCast(constantValue);
            }
            constant.setObject(constantValue);
            constant.setLength(operandLength);
            return constant;
        }
        if ("true".equals(operand) || "false".equals(operand)) {
            ConstantOperand constant = new ConstantOperand(source, operandStart, operandStart - position, operandLength);
            constant.setObject(new Boolean(operand));
            constant.setLength(operandLength);
            return constant;
        }
        if (forceConstant) {
            ConstantOperand constant = new ConstantOperand(source, operandStart, operandStart - position, operandLength);
            constant.setObject(operand);
            constant.setLength(operandLength);
            return constant;
        }
        VariableOperand variable = new VariableOperand(source, operandStart, operandStart - position, operandLength);
        variable.setForcedType(castType);
        variable.setVariable(operand);
        variable.setLength(operandLength);
        variable.setNegative(signedNegative);
        return variable;
    }

    private Number parseNumber(String text) throws NumberFormatException {
        Number number = null;
        number = text.indexOf(46) > -1 ? (Number)new Double(text) : (Number)(text.startsWith("0x") ? new Long(Long.parseLong(text.substring(2), 16)) : new Long(text));
        return number;
    }

    private ExpressionTuple scanExpression(char[] expression, int offset, int lastPos) throws ExpressionException {
        int length = expression.length;
        int parenthesisCount = 0;
        int exprStart = -1;
        for (int i = offset; i <= lastPos; ++i) {
            char c = expression[i];
            if (c == '$') {
                if (i >= length - 1 || expression[i + 1] != '{') continue;
                if (exprStart < 0) {
                    exprStart = i + 2;
                }
                ++parenthesisCount;
                continue;
            }
            if (c != '}') continue;
            if (--parenthesisCount == 0) {
                ExpressionTuple tuple = new ExpressionTuple(expression, exprStart, exprStart - offset, i - exprStart);
                tuple.setTotalPosition(exprStart - 2);
                tuple.setTotalLength(tuple.getLength() + 3);
                return tuple;
            }
            if (parenthesisCount >= 0) continue;
            parenthesisCount = 0;
        }
        if (parenthesisCount > 0) {
            throw new ExpressionException("Expression was not terminated correctly in text '" + new String(expression, offset, expression.length - offset) + "'.");
        }
        return null;
    }

    public String evalStringOperand(Operand operand, ExpressionContext ctx) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return null;
        }
        FormatHelper formatHelper = ctx.getFormatHelper();
        if (result instanceof Date) {
            if (result instanceof Time) {
                return formatHelper.getTimeFormat().format(result);
            }
            if (result instanceof Timestamp) {
                return formatHelper.getTimestampFormat().format(result);
            }
            return formatHelper.getDateFormat().format(result);
        }
        if (result instanceof Double || result instanceof BigDecimal || result instanceof Float) {
            double val = ((Number)result).doubleValue();
            if (Double.isInfinite(val) || Double.isNaN(val)) {
                return "-";
            }
            return formatHelper.getDoubleFormat().format(result);
        }
        if (result instanceof Number) {
            return formatHelper.getIntegerFormat().format(result);
        }
        return result.toString();
    }

    public char evalCharOperand(Operand operand, ExpressionContext ctx) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return '\u0000';
        }
        if (result instanceof Character) {
            return ((Character)result).charValue();
        }
        String value = result.toString();
        if (value.length() > 0) {
            return value.charAt(0);
        }
        return '\u0000';
    }

    public boolean evalBooleanOperand(Operand operand, ExpressionContext ctx) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return new Boolean(result.toString());
    }

    public byte evalByteOperand(Operand operand, ExpressionContext ctx) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0;
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        String value = result.toString();
        try {
            if (value.startsWith("0x")) {
                return Byte.parseByte(value.substring(2), 16);
            }
            return Byte.parseByte(value);
        }
        catch (NumberFormatException ex) {
            throw new OperandException("Detected invalid byte expression :'" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public int evalIntOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (!useFormat) {
            try {
                String value = result.toString();
                if (value.startsWith("0x")) {
                    return Integer.parseInt(value.substring(2), 16);
                }
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new OperandException("Detected invalid integer expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
            }
        }
        try {
            return ctx.getFormatHelper().getIntegerFormat().parse(result.toString()).intValue();
        }
        catch (ParseException pex) {
            throw new OperandException("Detected invalid integer expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public short evalShortOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0;
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        if (!useFormat) {
            try {
                String value = result.toString();
                if (value.startsWith("0x")) {
                    return Short.parseShort(value.substring(2), 16);
                }
                return Short.parseShort(value);
            }
            catch (NumberFormatException ex) {
                throw new OperandException("Detected invalid short expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
            }
        }
        try {
            return ctx.getFormatHelper().getIntegerFormat().parse(result.toString()).shortValue();
        }
        catch (ParseException pex) {
            throw new OperandException("Detected invalid short expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public long evalLongOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0L;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        if (!useFormat) {
            try {
                String value = result.toString();
                if (value.startsWith("0x")) {
                    return Long.parseLong(value.substring(2), 16);
                }
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                throw new OperandException("Detected invalid long expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
            }
        }
        try {
            return ctx.getFormatHelper().getIntegerFormat().parse(result.toString()).longValue();
        }
        catch (ParseException pex) {
            throw new OperandException("Detected invalid long expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public double evalDoubleOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0.0;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        if (!useFormat) {
            try {
                return Double.parseDouble(result.toString());
            }
            catch (NumberFormatException ex) {
                throw new OperandException("Detected invalid double expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
            }
        }
        try {
            return ctx.getFormatHelper().getDoubleFormat().parse(result.toString()).doubleValue();
        }
        catch (ParseException pex) {
            throw new ExpressionException("Detected invalid double expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public float evalFloatOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            return 0.0f;
        }
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        if (!useFormat) {
            try {
                return Float.parseFloat(result.toString());
            }
            catch (NumberFormatException ex) {
                throw new OperandException("Detected invalid float expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
            }
        }
        try {
            return ctx.getFormatHelper().getDoubleFormat().parse(result.toString()).floatValue();
        }
        catch (ParseException pex) {
            throw new ExpressionException("Detected invalid float expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public Date evalDateOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            throw new OperandException("Date expression '" + operand.getCode() + "' resolved to null!");
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        String strValue = result.toString();
        try {
            if (useFormat) {
                return ctx.getFormatHelper().getDateFormat().parse(strValue);
            }
            return this.intDateFormat.parse(strValue);
        }
        catch (ParseException ex) {
            if (!useFormat) {
                try {
                    return this.intDateFormat.parse(strValue);
                }
                catch (ParseException pex) {
                    // empty catch block
                }
            }
            throw new OperandException("Detected invalid Date expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public Time evalTimeOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            throw new OperandException("Time expression '" + operand.getCode() + "' resolved to null!");
        }
        if (result instanceof Time) {
            return (Time)result;
        }
        String strValue = result.toString();
        try {
            if (useFormat) {
                return new Time(ctx.getFormatHelper().getTimeFormat().parse(strValue).getTime());
            }
            return new Time(this.intTimeFormat.parse(strValue).getTime());
        }
        catch (ParseException ex) {
            if (!useFormat) {
                try {
                    return new Time(this.intTimeFormat.parse(strValue).getTime());
                }
                catch (ParseException pex) {
                    // empty catch block
                }
            }
            throw new OperandException("Detected invalid Time expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public Timestamp evalTimestampOperand(Operand operand, ExpressionContext ctx, boolean useFormat) throws ExpressionException {
        Object result = this.evalOperand(operand, ctx);
        if (result == null) {
            throw new OperandException("Timestamp expression '" + operand.getCode() + "' resolved to null!");
        }
        if (result instanceof Timestamp) {
            return (Timestamp)result;
        }
        String strValue = result.toString();
        try {
            if (useFormat) {
                return new Timestamp(ctx.getFormatHelper().getTimestampFormat().parse(strValue).getTime());
            }
            return new Timestamp(this.intTimestampFormat.parse(strValue).getTime());
        }
        catch (ParseException ex) {
            if (!useFormat) {
                try {
                    return new Timestamp(this.intTimestampFormat.parse(strValue).getTime());
                }
                catch (ParseException pex) {
                    // empty catch block
                }
            }
            throw new OperandException("Detected invalid Timestamp expression: '" + result.toString() + "' as result of expression '" + operand.getCode() + "'.");
        }
    }

    public Object evalOperand(Operand operand, ExpressionContext ctx) throws ExpressionException {
        ExpressionType forcedType = operand.getForcedType();
        if (!operand.isSimple()) {
            Object result = this.evalExpr((ExpressionTuple)operand, ctx);
            if (forcedType != null) {
                return forcedType.typeCast(result);
            }
            return result;
        }
        if (operand instanceof VariableOperand) {
            String value;
            VariableOperand variable = (VariableOperand)operand;
            String variableName = variable.getVariable();
            Object objectValue = this.getParameterValue(variableName, ctx);
            if (variable.isNegative() && objectValue instanceof Number) {
                BaseNumberType typeHandler = (BaseNumberType)this.getTypeHandler(objectValue);
                objectValue = typeHandler.getNegative((Number)objectValue);
            }
            variable.setObject(objectValue);
            if (objectValue != null && objectValue instanceof String && (value = (String)objectValue).length() > 0 && value.charAt(0) == '$') {
                objectValue = this.evalObject(value, ctx);
                if (forcedType != null) {
                    objectValue = forcedType.typeCast(objectValue);
                }
                return objectValue;
            }
            objectValue = variable.getValue();
            if (forcedType != null) {
                objectValue = forcedType.typeCast(objectValue);
            }
            return objectValue;
        }
        ConstantOperand constant = (ConstantOperand)operand;
        return constant.getObject();
    }

    public Object evalExpr(ExpressionTuple expr, Map params, Object bean, FormatHelper formatHelper) throws ExpressionException {
        return this.evalExpr(expr, new ExpressionContext(params, bean, formatHelper));
    }

    public Object evalExpr(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
        Operand object = expr.getObject();
        String paramName = null;
        if (object.isSimple()) {
            if (object instanceof VariableOperand) {
                String value;
                VariableOperand variable = (VariableOperand)object;
                paramName = variable.getVariable();
                Object objectValue = this.getParameterValue(paramName, ctx);
                if (variable.isNegative() && objectValue instanceof Number) {
                    BaseNumberType typeHandler = (BaseNumberType)this.getTypeHandler(objectValue);
                    objectValue = typeHandler.getNegative((Number)objectValue);
                }
                variable.setObject(objectValue);
                if (objectValue != null && objectValue instanceof String && (value = (String)objectValue).length() > 0 && value.charAt(0) == '$') {
                    objectValue = this.evalObject(value, ctx);
                    variable.setObject(objectValue);
                }
            }
        } else {
            ExpressionTuple objectExpression = (ExpressionTuple)expr.getObject();
            objectExpression.setResult(this.evalExpr(objectExpression, ctx));
        }
        Operation operation = expr.getOperation();
        Operand operand = expr.getOperand();
        if (operation == null && operand == null) {
            expr.setResult(object.getValue());
            return expr.getValue();
        }
        ExpressionType handler = this.getTypeHandler(object.getValue());
        return handler.evalTuple(expr, ctx);
    }

    protected Collection getTypeHandlers() {
        return this.typeHandlers.values();
    }

    protected ExpressionType getTypeHandler(Object object) {
        if (object == null) {
            return (ExpressionType)this.typeHandlers.get(NULL_VALUE_TYPE);
        }
        ExpressionType handler = (ExpressionType)this.typeHandlers.get(object.getClass());
        if (handler != null) {
            return handler;
        }
        Collection typeList = this.typeHandlers.values();
        Iterator iterTypeList = typeList.iterator();
        while (iterTypeList.hasNext()) {
            ExpressionType type = (ExpressionType)iterTypeList.next();
            Class typeClass = type.getType();
            if (typeClass.equals(DEFAULT_TYPE) || !type.getType().isInstance(object)) continue;
            return type;
        }
        return (ExpressionType)this.typeHandlers.get(DEFAULT_TYPE);
    }

    protected ExpressionType getTypeByName(String name) throws ExpressionException {
        if (name == null) {
            throw new ExpressionException("No handler declared for null type!");
        }
        ExpressionType handler = (ExpressionType)this.typeNameMap.get(name);
        if (handler != null) {
            return handler;
        }
        throw new ExpressionException("No handler declared for type '" + name + "'!");
    }

    public static void main(String[] args) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        if (args.length != 0) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(args[0]));
                properties.putAll(props);
            }
            catch (IOException ex) {
                System.err.println("Unable to load properties from file '" + properties + "'.");
                System.exit(1);
            }
        }
        ExpressionInterpreter exi = ExpressionInterpreter.createInstance();
        FormatHelper formatHelper = FormatHelper.createInstance();
        BufferedReader cmdReader = new BufferedReader(new InputStreamReader(System.in));
        block6: while (true) {
            try {
                while (true) {
                    System.out.print("exi>");
                    String expr = cmdReader.readLine().trim();
                    try {
                        if (expr.equalsIgnoreCase("exit")) break block6;
                        System.out.println(exi.evalObject(expr, properties, formatHelper));
                        continue block6;
                    }
                    catch (ExpressionException ex) {
                        System.err.println("Evaluation failed: " + ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                break;
            }
        }
    }

    public Object clone() {
        ExpressionInterpreter clone = null;
        try {
            clone = (ExpressionInterpreter)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone ExpressionInterpreter instance: " + ex.getMessage(), ex);
        }
        clone.typeHandlers = (Map)((HashMap)this.typeHandlers).clone();
        return clone;
    }

    static {
        operationPriorityMap.put(".", new Integer(10));
        operationPriorityMap.put("*", new Integer(9));
        operationPriorityMap.put("/", new Integer(9));
        operationPriorityMap.put("%", new Integer(9));
        operationPriorityMap.put("+", new Integer(8));
        operationPriorityMap.put("-", new Integer(8));
        operationPriorityMap.put("<", new Integer(6));
        operationPriorityMap.put(">", new Integer(6));
        operationPriorityMap.put(">=", new Integer(6));
        operationPriorityMap.put("<=", new Integer(6));
        operationPriorityMap.put("==", new Integer(6));
        operationPriorityMap.put("&&", new Integer(5));
        operationPriorityMap.put("and", new Integer(5));
        operationPriorityMap.put("||", new Integer(4));
        operationPriorityMap.put("or", new Integer(4));
    }
}

