/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.NumberFormat;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.TypeCastException;
import org.ujac.util.exi.type.BaseNumberType;
import org.ujac.util.text.FormatHelper;

public class ByteType
extends BaseNumberType {
    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Number value = (Number)expr.getObject().getValue();
        NumberFormat format = formatHelper.getIntegerFormat();
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public ByteType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new GreaterOperation();
        this.addOperation(">", op);
        this.addOperation("gt", op);
        op = new GreaterEqualOperation();
        this.addOperation(">=", op);
        this.addOperation("ge", op);
        op = new LessOperation();
        this.addOperation("<", op);
        this.addOperation("lt", op);
        op = new LessEqualOperation();
        this.addOperation("<=", op);
        this.addOperation("le", op);
        op = new AddOperation();
        this.addOperation("+", op);
        this.addOperation("add", op);
        op = new SubOperation();
        this.addOperation("-", op);
        this.addOperation("sub", op);
        op = new MulOperation();
        this.addOperation("*", op);
        this.addOperation("mul", op);
        op = new DivOperation();
        this.addOperation("/", op);
        this.addOperation("div", op);
        op = new ModOperation();
        this.addOperation("%", op);
        this.addOperation("mod", op);
        this.addOperation("min", new MinOperation());
        this.addOperation("max", new MaxOperation());
        this.addOperation("abs", new AbsOperation());
    }

    public Class getType() {
        return Byte.class;
    }

    public String getAlias() {
        return "byte";
    }

    public Number getNegative(Number number) {
        return new Byte((byte)(number.byteValue() * -1));
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value instanceof String) {
            String strValue = (String)value;
            try {
                byte byteVal = Byte.parseByte(strValue);
                return new Byte(byteVal);
            }
            catch (NumberFormatException ex) {
                throw new TypeCastException("Unable to parse byte value from '" + strValue + "'.");
            }
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        throw new TypeCastException("Unable to transform value '" + value + "' into a byte.");
    }

    public class AbsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Number object = (Number)expr.getObject().getValue();
            return new Byte((byte)Math.abs(object.byteValue()));
        }

        public String getDescription() {
            return "Determines the object's absolute value.";
        }
    }

    public class MaxOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            Number object = (Number)expr.getObject().getValue();
            if (object.byteValue() > operandValue) {
                return object;
            }
            return new Byte(operandValue);
        }

        public String getDescription() {
            return "Gets the maximum of the object and the operand value.";
        }
    }

    public class MinOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            Number object = (Number)expr.getObject().getValue();
            if (object.byteValue() < operandValue) {
                return object;
            }
            return new Byte(operandValue);
        }

        public String getDescription() {
            return "Gets the minimum of the object and the operand value.";
        }
    }

    public class ModOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ByteType.this.interpreter.evalIntOperand(operand, ctx, false);
            return new Integer(((Number)expr.getObject().getValue()).byteValue() % operandValue);
        }

        public String getDescription() {
            return "Calculates the modulo of the object and the operand value.";
        }
    }

    public class DivOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ByteType.this.interpreter.evalIntOperand(operand, ctx, false);
            return new Integer(((Number)expr.getObject().getValue()).byteValue() / operandValue);
        }

        public String getDescription() {
            return "Calculates the quotient of the object and the operand value.";
        }
    }

    public class MulOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ByteType.this.interpreter.evalIntOperand(operand, ctx, false);
            return new Integer(((Number)expr.getObject().getValue()).byteValue() * operandValue);
        }

        public String getDescription() {
            return "Calculates the product of the object and the operand value.";
        }
    }

    public class SubOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ByteType.this.interpreter.evalIntOperand(operand, ctx, false);
            return new Integer(((Number)expr.getObject().getValue()).byteValue() - operandValue);
        }

        public String getDescription() {
            return "Calculates the difference of the object and the operand value.";
        }
    }

    public class AddOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ByteType.this.interpreter.evalIntOperand(operand, ctx, false);
            return new Integer(((Number)expr.getObject().getValue()).byteValue() + operandValue);
        }

        public String getDescription() {
            return "Calculates the sum of the object and the operand value.";
        }
    }

    public class LessEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() <= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than or equal to the operand.";
        }
    }

    public class GreaterEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() >= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than or equal to the operand.";
        }
    }

    public class LessOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() < operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than the operand.";
        }
    }

    public class GreaterOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() > operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than the operand.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() != operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            byte operandValue = ByteType.this.interpreter.evalByteOperand(operand, ctx);
            return new Boolean(((Number)expr.getObject().getValue()).byteValue() == operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

