/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseDateType;
import org.ujac.util.text.FormatHelper;

public class DateType
extends BaseDateType {
    protected Date evalDate(Operand operand, ExpressionContext ctx) throws ExpressionException {
        return this.interpreter.evalDateOperand(operand, ctx, false);
    }

    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Date value = (Date)expr.getObject().getValue();
        DateFormat format = formatHelper.getDateFormat();
        if (format != null) {
            return format.format((Object)value);
        }
        return value.toString();
    }

    protected int compareDates(Date object, Date operand) {
        Calendar objectCal = Calendar.getInstance();
        objectCal.setTime(object);
        Calendar operandCal = Calendar.getInstance();
        operandCal.setTime(operand);
        int objectYear = objectCal.get(1);
        int operandYear = operandCal.get(1);
        int objectMonth = objectCal.get(2);
        int operandMonth = operandCal.get(2);
        int objectDay = objectCal.get(5);
        int operandDay = operandCal.get(5);
        if (objectYear > operandYear) {
            return 1;
        }
        if (objectYear < operandYear) {
            return -1;
        }
        if (objectMonth > operandMonth) {
            return 1;
        }
        if (objectMonth < operandMonth) {
            return -1;
        }
        if (objectDay > operandDay) {
            return 1;
        }
        if (objectDay < operandDay) {
            return -1;
        }
        return 0;
    }

    public DateType(ExpressionInterpreter interpreter) {
        super(interpreter);
    }

    public Class getType() {
        return Date.class;
    }

    public String getAlias() {
        return "Date";
    }
}

