/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ujac.util.io.ResourceLoader;

public class CachedResourceLoader
implements ResourceLoader {
    private ResourceLoader resourceLoader = null;
    private Map resourceCache = new HashMap();

    public CachedResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public byte[] loadResource(String location) throws IOException {
        byte[] resource = (byte[])this.resourceCache.get(location);
        if (resource != null) {
            return resource;
        }
        resource = this.resourceLoader.loadResource(location);
        this.resourceCache.put(location, resource);
        return resource;
    }

    public boolean resourceExists(String location) {
        byte[] resource = (byte[])this.resourceCache.get(location);
        if (resource != null) {
            return true;
        }
        return this.resourceLoader.resourceExists(location);
    }

    public void clearCache() {
        this.resourceCache.clear();
    }
}

