/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ujac.util.io.ResourceLoader;

public class ClassPathResourceLoader
implements ResourceLoader {
    public static final int IO_BUFFER_SIZE = 2048;
    private ClassLoader classLoader = null;
    private String pathPrefix = null;

    public ClassPathResourceLoader(ClassLoader classLoader) throws IOException {
        if (classLoader == null) {
            throw new IOException("The class loader mustn't be null.");
        }
        this.classLoader = classLoader;
    }

    public ClassPathResourceLoader(ClassLoader classLoader, String pathPrefix) throws IOException {
        this(classLoader);
        this.pathPrefix = pathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadResource(String location) throws IOException {
        if (location == null || location.length() == 0) {
            throw new IOException("The given resource location must not be null and non empty.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String path = location;
        if (this.pathPrefix != null) {
            path = this.pathPrefix + "/" + location;
        }
        InputStream cpis = this.classLoader.getResourceAsStream(path);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(cpis, 2048);
            byte[] buffer = new byte[2048];
            int numRead = is.read(buffer, 0, 2048);
            while (numRead > 0) {
                bos.write(buffer, 0, numRead);
                numRead = is.read(buffer, 0, 2048);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (cpis != null) {
                cpis.close();
            }
        }
        return bos.toByteArray();
    }

    public boolean resourceExists(String location) {
        InputStream cpis;
        if (location == null || location.length() == 0) {
            return false;
        }
        String path = location;
        if (this.pathPrefix != null) {
            path = this.pathPrefix + "/" + location;
        }
        if ((cpis = this.classLoader.getResourceAsStream(path)) == null) {
            return false;
        }
        try {
            cpis.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return true;
    }
}

