/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ujac.util.io.ResourceLoader;

public class MultiResourceLoader
implements ResourceLoader {
    private List resourceLoaders = new ArrayList();

    public void addResourceLoader(ResourceLoader resourceLoader) {
        if (this.resourceLoaders == null) {
            this.resourceLoaders = new ArrayList();
        }
        this.resourceLoaders.add(resourceLoader);
    }

    public byte[] loadResource(String location) throws IOException {
        int numResourceLoaders = this.resourceLoaders.size();
        if (numResourceLoaders == 0) {
            throw new IOException("No resource loaders specified!");
        }
        for (int i = 0; i < numResourceLoaders; ++i) {
            ResourceLoader resourceLoader = (ResourceLoader)this.resourceLoaders.get(i);
            try {
                return resourceLoader.loadResource(location);
            }
            catch (IOException ex) {
                if (i < numResourceLoaders - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    public boolean resourceExists(String location) {
        int numResourceLoaders = this.resourceLoaders.size();
        if (numResourceLoaders == 0) {
            return false;
        }
        for (int i = 0; i < numResourceLoaders; ++i) {
            ResourceLoader resourceLoader = (ResourceLoader)this.resourceLoaders.get(i);
            if (!resourceLoader.resourceExists(location)) continue;
            return true;
        }
        return false;
    }
}

