/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import org.ujac.util.table.Column;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Table;
import org.ujac.util.text.FormatHelper;

public class DefaultColumn
implements Column,
Serializable {
    static final long serialVersionUID = -7084479108164808073L;
    private Table table = null;
    private String name;
    private boolean key = false;
    private int type;
    private String alias;
    private Format format;
    private int index = -1;
    private int dataIndex = -1;
    private LayoutHints layoutHints;

    protected DefaultColumn(Table table, String name, int type) {
        this.table = table;
        this.name = name;
        this.type = type;
    }

    protected DefaultColumn(Table table, String name, boolean key, int type) {
        this.table = table;
        this.name = name;
        this.key = key;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public boolean isKey() {
        return this.key;
    }

    public Column setKey(boolean key) {
        this.key = key;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getAlias() {
        return this.alias;
    }

    public Column setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public Format getFormat() {
        if (this.format != null) {
            return this.format;
        }
        if (this.table == null) {
            return null;
        }
        FormatHelper fh = this.table.getFormatHelper();
        switch (this.type) {
            case 2: 
            case 4: {
                return fh.getIntegerFormat();
            }
            case 5: 
            case 6: {
                return fh.getDoubleFormat();
            }
            case 8: {
                return fh.getDateFormat();
            }
            case 9: {
                return fh.getTimeFormat();
            }
            case 10: {
                return fh.getTimestampFormat();
            }
        }
        return null;
    }

    public Column setFormat(Format format) {
        this.format = format;
        return this;
    }

    public Column setFormat(String format) {
        switch (this.type) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.format = this.table.getFormatHelper().createNumberFormat(format);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.format = this.table.getFormatHelper().createDateFormat(format);
            }
        }
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public Column setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public Column setDataIndex(int dataIndex) {
        this.dataIndex = dataIndex;
        return this;
    }

    public LayoutHints getLayoutHints() {
        return this.layoutHints;
    }

    public Column setLayoutHints(LayoutHints layoutHints) {
        this.layoutHints = layoutHints;
        return this;
    }

    public String getTypeName() {
        switch (this.type) {
            case 1: {
                return "String";
            }
            case 2: {
                return "int";
            }
            case 4: {
                return "long";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "boolean";
            }
            case 8: {
                return "Date";
            }
            case 9: {
                return "Time";
            }
            case 10: {
                return "Timestamp";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "{name=" + this.name + ", type=" + this.getTypeName() + ", alias=" + this.alias + ", index=" + this.index + ", layoutHints=" + this.layoutHints + "}";
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        s.writeObject(this.table);
        s.writeObject(this.name);
        s.writeBoolean(this.key);
        s.writeInt(this.type);
        s.writeObject(this.alias);
        s.writeObject(this.format);
        s.writeInt(this.index);
        s.writeInt(this.dataIndex);
        s.writeObject(this.layoutHints);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.table = (Table)s.readObject();
        this.name = (String)s.readObject();
        this.key = s.readBoolean();
        this.type = s.readInt();
        this.alias = (String)s.readObject();
        this.format = (Format)s.readObject();
        this.index = s.readInt();
        this.dataIndex = s.readInt();
        this.layoutHints = (LayoutHints)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

