/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.ujac.util.table.BaseRow;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TypeMismatchException;

public class HeaderRow
extends BaseRow
implements Row {
    static final long serialVersionUID = 523137629281968928L;

    protected HeaderRow(Table table) {
        super(table);
    }

    public String getType() {
        return "header";
    }

    public int getIndex() {
        return -1;
    }

    public String getString(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        return this.getString(column.getIndex());
    }

    public String getString(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        LayoutHints layoutHints = column.getLayoutHints();
        if (layoutHints != null) {
            return layoutHints.getHeader();
        }
        return null;
    }

    public void setString(String columnName, String value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnName);
        this.setString(column.getIndex(), value);
    }

    public void setString(int columnIdx, String value) throws ColumnNotDefinedException, TypeMismatchException {
        Column column = this.table.getColumn(columnIdx);
        LayoutHints layoutHints = column.getLayoutHints();
        if (layoutHints == null) {
            layoutHints = new LayoutHints();
            column.setLayoutHints(layoutHints);
        }
        layoutHints.setHeader(value);
    }

    public int getInt(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public int getInt(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setInt(String columnName, int value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setInt(int columnIdx, int value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public long getLong(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public long getLong(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setLong(String columnName, long value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setLong(int columnIdx, long value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public float getFloat(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public float getFloat(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setFloat(String columnName, float value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setFloat(int columnIdx, float value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public double getDouble(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public double getDouble(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setDouble(String columnName, double value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setDouble(int columnIdx, double value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public boolean getBoolean(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public boolean getBoolean(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setBoolean(String columnName, boolean value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setBoolean(int columnIdx, boolean value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getDate(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getDate(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setDate(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setDate(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getTime(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getTime(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setTime(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setTime(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getTimestamp(String columnName) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Date getTimestamp(int columnIdx) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setTimestamp(String columnName, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public void setTimestamp(int columnIdx, Date value) throws ColumnNotDefinedException, TypeMismatchException {
        throw new TypeMismatchException("Only Strings are supported for title rows.");
    }

    public Object getObject(String columnName) throws ColumnNotDefinedException {
        try {
            return this.getString(columnName);
        }
        catch (TypeMismatchException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public Object getObject(int columnIdx) throws ColumnNotDefinedException {
        try {
            return this.getString(columnIdx);
        }
        catch (TypeMismatchException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setObject(String columnName, Object value) throws ColumnNotDefinedException, TypeMismatchException {
        this.setString(columnName, value.toString());
    }

    public void setObject(int columnIdx, Object value) throws ColumnNotDefinedException, TypeMismatchException {
        this.setString(columnIdx, value.toString());
    }

    protected int getFieldAlignment(LayoutHints lh) {
        if (lh != null) {
            return lh.getHeaderAlign();
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

