/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ujac.util.table.FunctionExecutor;
import org.ujac.util.table.ReportTable;
import org.ujac.util.table.Row;
import org.ujac.util.table.TypeMismatchException;

public class ReportGroup
implements Cloneable,
Serializable {
    static final long serialVersionUID = 3181590254515459952L;
    private String columnName = null;
    private boolean viewTitleRow;
    private boolean resultsInTitleRow;
    private boolean hideAtSucceedingRows;
    private boolean startNewPage;
    private boolean keepTogether;
    private boolean enforceResultRow;
    private int columnIdx = -1;
    private ReportTable report = null;
    private double[] results = null;
    private boolean[] functionsApplied = null;
    private Row titleRow = null;

    public ReportGroup(String columnName) {
        this.columnName = columnName;
    }

    public ReportGroup(String columnName, boolean viewTitleRow, boolean resultsInTitleRow, boolean hideAtSucceedingRows, boolean startNewPage) {
        this(columnName, viewTitleRow, resultsInTitleRow, hideAtSucceedingRows, startNewPage, false);
    }

    public ReportGroup(String columnName, boolean viewTitleRow, boolean resultsInTitleRow, boolean hideAtSucceedingRows, boolean startNewPage, boolean keepTogether) {
        this.columnName = columnName;
        this.viewTitleRow = viewTitleRow;
        this.resultsInTitleRow = resultsInTitleRow;
        this.hideAtSucceedingRows = hideAtSucceedingRows;
        this.startNewPage = startNewPage;
        this.keepTogether = keepTogether;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isViewTitleRow() {
        return this.viewTitleRow;
    }

    public ReportGroup setViewTitleRow(boolean viewTitleRow) {
        this.viewTitleRow = viewTitleRow;
        return this;
    }

    public boolean isResultsInTitleRow() {
        return this.resultsInTitleRow;
    }

    public ReportGroup setResultsInTitleRow(boolean resultsInTitleRow) {
        this.resultsInTitleRow = resultsInTitleRow;
        return this;
    }

    public boolean isHideAtSucceedingRows() {
        return this.hideAtSucceedingRows;
    }

    public ReportGroup setHideAtSucceedingRows(boolean hideAtSucceedingRows) {
        this.hideAtSucceedingRows = hideAtSucceedingRows;
        return this;
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public ReportGroup setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
        return this;
    }

    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    public ReportGroup setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
        return this;
    }

    public boolean isEnforceResultRow() {
        return this.enforceResultRow;
    }

    public ReportGroup setEnforceResultRow(boolean enforceResultRow) {
        this.enforceResultRow = enforceResultRow;
        return this;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    protected ReportGroup setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
        return this;
    }

    public double[] getGroupResults() {
        return this.results;
    }

    public double getGroupResult(int columnId) {
        return this.results[columnId];
    }

    protected boolean isFunctionsApplied() {
        for (int i = 0; i < this.functionsApplied.length; ++i) {
            if (!this.functionsApplied[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean isFunctionsApplied(int columnId) {
        return this.functionsApplied[columnId];
    }

    protected void applyFunction(int columnId, FunctionExecutor executor, Object operand) throws TypeMismatchException {
        this.results[columnId] = executor.execute(this.results[columnId], operand);
        this.functionsApplied[columnId] = true;
    }

    protected Row getTitleRow() {
        return this.titleRow;
    }

    protected void setTitleRow(Row titleRow) {
        this.titleRow = titleRow;
    }

    protected void init(ReportTable report) {
        this.report = report;
        this.results = new double[report.getColumnCount()];
        this.functionsApplied = new boolean[report.getColumnCount()];
    }

    protected void reset() {
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = 0.0;
            this.functionsApplied[i] = false;
        }
    }

    protected Object clone() {
        ReportGroup clone = null;
        try {
            clone = (ReportGroup)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone ReportGroup instance: " + ex.getMessage(), ex);
        }
        return clone;
    }

    public String toString() {
        return "{columnName=" + this.columnName + ", viewTitleRow=" + this.viewTitleRow + ", resultsInTitleRow=" + this.resultsInTitleRow + ", hideAtSucceedingRows=" + this.hideAtSucceedingRows + ", startNewPage=" + this.startNewPage + ", keepTogether=" + this.keepTogether + ", enforceResultRow=" + this.enforceResultRow + ", columnIdx=" + this.columnIdx + "}";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.columnName);
        s.writeBoolean(this.viewTitleRow);
        s.writeBoolean(this.resultsInTitleRow);
        s.writeBoolean(this.hideAtSucceedingRows);
        s.writeBoolean(this.startNewPage);
        s.writeBoolean(this.keepTogether);
        s.writeBoolean(this.enforceResultRow);
        s.writeInt(this.columnIdx);
        s.writeObject(this.report);
        s.writeObject(this.results);
        s.writeObject(this.functionsApplied);
        s.writeObject(this.titleRow);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.columnName = (String)s.readObject();
        this.viewTitleRow = s.readBoolean();
        this.resultsInTitleRow = s.readBoolean();
        this.hideAtSucceedingRows = s.readBoolean();
        this.startNewPage = s.readBoolean();
        this.keepTogether = s.readBoolean();
        this.enforceResultRow = s.readBoolean();
        this.columnIdx = s.readInt();
        this.report = (ReportTable)s.readObject();
        this.results = (double[])s.readObject();
        this.functionsApplied = (boolean[])s.readObject();
        this.titleRow = (Row)s.readObject();
    }
}

