/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.TableConstants;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;
import org.ujac.util.text.FormatHelper;

public interface Table
extends TableConstants {
    public FormatHelper getFormatHelper();

    public void setFormatHelper(FormatHelper var1);

    public TypeConverter getTypeConverter();

    public void setTypeConverter(TypeConverter var1);

    public int getColumnCount();

    public Column getColumn(int var1) throws ColumnNotDefinedException;

    public Column getColumn(String var1) throws ColumnNotDefinedException;

    public int getColumnIndex(String var1) throws ColumnNotDefinedException;

    public void renameColumn(Column var1, String var2) throws ColumnAlreadyDefinedException;

    public void orderColumns(String[] var1) throws ColumnNotDefinedException, ColumnAlreadyDefinedException;

    public Column[] getVisibleColumns();

    public Column[] getVisibleColumns(int var1);

    public Row getHeaderRow();

    public Iterator iterator();

    public Column addColumn(String var1, int var2) throws ColumnAlreadyDefinedException, OperationNotSupportedException;

    public Column addColumn(String var1, int var2, LayoutHints var3) throws ColumnAlreadyDefinedException, OperationNotSupportedException;

    public Table addString(String var1, String var2) throws TableException;

    public Table addInt(String var1, int var2) throws TableException;

    public Table addLong(String var1, long var2) throws TableException;

    public Table addFloat(String var1, float var2) throws TableException;

    public Table addDouble(String var1, double var2) throws TableException;

    public Table addBoolean(String var1, boolean var2) throws TableException;

    public Table addDate(String var1, Date var2) throws TableException;

    public Table addTime(String var1, Date var2) throws TableException;

    public Table addTimestamp(String var1, Date var2) throws TableException;

    public boolean isEmpty();

    public int getRowCount() throws OperationNotSupportedException;

    public Row addRow() throws OperationNotSupportedException;

    public Row addRow(Row var1) throws OperationNotSupportedException;

    public Row getRow(int var1) throws RowNotDefinedException, OperationNotSupportedException;

    public void removeRow(int var1) throws RowNotDefinedException, OperationNotSupportedException;

    public String getString(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public String getString(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setString(int var1, int var2, String var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setString(int var1, String var2, String var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public int getInt(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public int getInt(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setInt(int var1, int var2, int var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setInt(int var1, String var2, int var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public long getLong(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public long getLong(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setLong(int var1, int var2, long var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setLong(int var1, String var2, long var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public float getFloat(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public float getFloat(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setFloat(int var1, int var2, float var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setFloat(int var1, String var2, float var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public double getDouble(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public double getDouble(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setDouble(int var1, int var2, double var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setDouble(int var1, String var2, double var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public boolean getBoolean(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public boolean getBoolean(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setBoolean(int var1, int var2, boolean var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setBoolean(int var1, String var2, boolean var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getDate(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getDate(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setDate(int var1, int var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setDate(int var1, String var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getTime(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getTime(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setTime(int var1, int var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setTime(int var1, String var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getTimestamp(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Date getTimestamp(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setTimestamp(int var1, int var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setTimestamp(int var1, String var2, Date var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public Object getObject(int var1, int var2) throws RowNotDefinedException, ColumnNotDefinedException;

    public Object getObject(int var1, String var2) throws RowNotDefinedException, ColumnNotDefinedException;

    public void setObject(int var1, int var2, Object var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void setObject(int var1, String var2, Object var3) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException;

    public void sort(CompareItem[] var1) throws OperationNotSupportedException;

    public void sort(int var1, int var2) throws OperationNotSupportedException;

    public void setColumnType(int var1, int var2) throws ColumnNotDefinedException, TypeConverterException;

    public void setColumnType(String var1, int var2) throws ColumnNotDefinedException, TypeConverterException;

    public Table copyTable() throws TableException;

    public Set getDistinctValues(int var1) throws TableException;

    public Set getDistinctValues(String var1) throws TableException;
}

