/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.AssertToken;
import org.ujac.util.template.CallprocToken;
import org.ujac.util.template.DefineToken;
import org.ujac.util.template.ElseToken;
import org.ujac.util.template.ElseifToken;
import org.ujac.util.template.ExpressionFilter;
import org.ujac.util.template.ForeachToken;
import org.ujac.util.template.IfToken;
import org.ujac.util.template.LogToken;
import org.ujac.util.template.ProcedureToken;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.template.TemplateRoot;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public abstract class BaseTemplateInterpreter
implements TemplateInterpreter {
    protected ExpressionInterpreter exi = null;
    protected Map tokenTypes = new HashMap();
    protected ExpressionFilter expressionFilter = null;

    public BaseTemplateInterpreter() {
        this.exi = ExpressionInterpreter.createInstance();
        this.registerTokenTypes();
    }

    public BaseTemplateInterpreter(ExpressionInterpreter exi) {
        this.exi = exi;
        this.registerTokenTypes();
    }

    protected BaseTemplateInterpreter(ExpressionInterpreter exi, Map tokenTypes) {
        this.exi = exi;
        this.tokenTypes = tokenTypes;
    }

    protected void registerTokenTypes() {
        this.tokenTypes.put("if", IfToken.class);
        this.tokenTypes.put("else", ElseToken.class);
        this.tokenTypes.put("elseif", ElseifToken.class);
        this.tokenTypes.put("foreach", ForeachToken.class);
        this.tokenTypes.put("procedure", ProcedureToken.class);
        this.tokenTypes.put("callproc", CallprocToken.class);
        this.tokenTypes.put("define", DefineToken.class);
        this.tokenTypes.put("assert", AssertToken.class);
        this.tokenTypes.put("log", LogToken.class);
    }

    public TemplateRoot parse(String source) throws TemplateException, IOException {
        if (source == null) {
            return null;
        }
        char[] code = source.toCharArray();
        return this.parse(code, 0, code.length);
    }

    public TemplateRoot parse(char[] source, int offset, int length) throws TemplateException, IOException {
        TemplateRoot root = new TemplateRoot(source, offset, length);
        this.parse(root);
        return root;
    }

    public abstract int parse(TemplateTokenContainer var1) throws TemplateException, IOException;

    public String execute(String template, TemplateContext ctx) throws TemplateException {
        try {
            TemplateRoot templateRoot = this.parse(template);
            if (templateRoot == null) {
                return null;
            }
            StringWriter writer = new StringWriter();
            this.execute(templateRoot, (Writer)writer, ctx);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void execute(String template, Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        TemplateRoot templateRoot = this.parse(template);
        this.execute(templateRoot, writer, ctx);
    }

    public void execute(TemplateRoot template, Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        template.execute(writer, ctx);
    }

    public final ExpressionTuple parseExpr(String source) throws ExpressionException {
        return this.exi.parseExpr(source);
    }

    public final ExpressionTuple parseExpr(char[] source, int offset, int lastPos) throws ExpressionException {
        return this.exi.parseExpr(source, offset, lastPos);
    }

    public final boolean evalBooleanExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalBooleanOperand(operand, ctx);
    }

    public final boolean evalBooleanExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalBoolean(expression, ctx);
    }

    public int evalIntExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalIntOperand(operand, ctx, false);
    }

    public int evalIntExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalInt(expression, ctx);
    }

    public long evalLongExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalLongOperand(operand, ctx, false);
    }

    public long evalLongExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalLong(expression, ctx);
    }

    public float evalFloatExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalFloatOperand(operand, ctx, false);
    }

    public float evalFloatExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalFloat(expression, ctx);
    }

    public double evalDoubleExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalDoubleOperand(operand, ctx, false);
    }

    public double evalDoubleExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalDouble(expression, ctx);
    }

    public Date evalDateExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalDateOperand(operand, ctx, false);
    }

    public Date evalDateExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalDate(expression, ctx);
    }

    public Time evalTimeExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalTimeOperand(operand, ctx, false);
    }

    public Time evalTimeExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalTime(expression, ctx);
    }

    public Timestamp evalTimestampExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalTimestampOperand(operand, ctx, false);
    }

    public Timestamp evalTimestampExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalTimestamp(expression, ctx);
    }

    public String evalStringExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalStringOperand(operand, ctx);
    }

    public String evalStringExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalString(expression, ctx);
    }

    public final Object evalObjectExpr(Operand operand, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalOperand(operand, ctx);
    }

    public final Object evalObjectExpr(String expression, TemplateContext ctx) throws ExpressionException {
        return this.exi.evalObject(expression, ctx);
    }

    public final TemplateToken createToken(String tokenName) throws StatementException {
        Class tc = this.getTokenType(tokenName);
        if (tc == null) {
            return null;
        }
        try {
            return (TemplateToken)tc.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new StatementException("template token instantiation failed.", ex);
        }
        catch (InstantiationException ex) {
            throw new StatementException("template token instantiation failed.", ex);
        }
    }

    public final Class getTokenType(String tokenName) {
        return (Class)this.tokenTypes.get(tokenName);
    }

    public ExpressionFilter getExpressionFilter() {
        return this.expressionFilter;
    }

    public void setExpressionFilter(ExpressionFilter expressionFilter) {
        this.expressionFilter = expressionFilter;
    }
}

