/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseConditionToken;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public class ElseToken
extends BaseConditionToken {
    private static final long serialVersionUID = 3258134673849659958L;
    public static final TokenAncestor[] ancestorRules = new TokenAncestor[]{new TokenAncestor("endif")};
    private BaseConditionToken rootCondition = null;

    public String getTokenName() {
        return "else";
    }

    public TokenAncestor[] getAncestorRules() {
        return ancestorRules;
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        this.setBodyStart(position + 6);
        this.rootCondition = this.getPreviousCondition().getRootCondition();
    }

    public void setArgument(Operand argument, int idx) throws StatementException {
        throw new StatementException("The else statement doesn't allow any argument.");
    }

    public boolean isTrue(TemplateContext ctx) throws ExpressionException {
        return !this.rootCondition.isResolved();
    }

    public BaseConditionToken getRootCondition() {
        return this.rootCondition;
    }

    public String toString() {
        return this.getIndention() + "_else_\n" + super.toString();
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        ElseToken clone = null;
        try {
            clone = (ElseToken)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
        clone.interpreter = interpreter;
        clone.parent = parent;
        try {
            clone.rootCondition = clone.getPreviousCondition().getRootCondition();
        }
        catch (StatementException ex) {
            throw new RuntimeException("Failed to set root condition: " + ex.getMessage(), ex);
        }
        clone.cloneChildTokens(this.procedureRegistry, this);
        return clone;
    }
}

