/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseConditionToken;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public class ElseifToken
extends BaseConditionToken {
    private static final long serialVersionUID = 3257572793259669817L;
    public static final TokenAncestor[] ancestorRules = new TokenAncestor[]{new TokenAncestor("elseif", true, true), new TokenAncestor("else", true), new TokenAncestor("endif")};
    private ExpressionTuple condition = null;
    private BaseConditionToken rootCondition = null;

    public String getTokenName() {
        return "elseif";
    }

    public TokenAncestor[] getAncestorRules() {
        return ancestorRules;
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        this.setBodyStart(this.parseArguments() + 1);
        this.rootCondition = this.getPreviousCondition().getRootCondition();
    }

    public void setArgument(Operand argument, int idx) {
        this.condition = (ExpressionTuple)argument;
    }

    public boolean isTrue(TemplateContext ctx) throws ExpressionException {
        if (this.rootCondition.isResolved()) {
            return false;
        }
        boolean cond = this.interpreter.evalBooleanExpr(this.condition, ctx);
        this.rootCondition.setResolved(cond);
        return cond;
    }

    public BaseConditionToken getRootCondition() {
        return this.rootCondition;
    }

    public String toString() {
        return this.getIndention() + "_elseif_(" + this.getArgumentsAsString() + ")\n" + super.toString();
    }

    protected String getArgumentsAsString() {
        return this.condition.toString();
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        ElseifToken clone = null;
        try {
            clone = (ElseifToken)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.condition = (ExpressionTuple)this.condition.clone();
        try {
            clone.rootCondition = clone.getPreviousCondition().getRootCondition();
        }
        catch (StatementException ex) {
            throw new RuntimeException("Failed to set root condition: " + ex.getMessage(), ex);
        }
        return clone;
    }
}

